---
title: "How to Schedule Lucit Campaigns in Clear Channel"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Clear Channel using multiple API format endpoints"
keywords: [lucit, clear channel, integration, digital signage, dynamic campaigns, api, json, xml]
---

# How to Schedule Lucit Campaigns in Clear Channel

## Integration Overview

Clear Channel integrates with Lucit through multiple API format endpoints supporting JSON, XML, IMAGE, VAST, and HTML formats. This integration requires coordination with Clear Channel's scheduling team who will implement the provided URLs into their system.

**Important Note**: For full Lucit capabilities with Clear Channel inventory, we recommend placing campaigns targeting Clear Channel screens through [Place Exchange](how-to-schedule-lucit-campaigns-in-place-exchange.md) to take advantage of full Lucit capabilities including enhanced programmatic features.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Clear Channel App Installed** - The Clear Channel app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Clear Channel Partnership** with scheduling team contact  
✅ **Billboard Location IDs** from Clear Channel system  
✅ **Preferred API Format** (coordinate with Clear Channel technical team)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Clear Channel App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Clear Channel** app appears in your list
   - If not visible, click **ADD NEW** and add the Clear Channel app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Clear Channel Tab**
   - In the Link Player dialog, locate the **Clear Channel** tab
   - If you don't see the Clear Channel tab, return to Step 2 to add the app
   - Click on the **Clear Channel** tab to view integration options

7. **Gather Campaign Information**
   - Note the **Campaign Hash ID** displayed in the Clear Channel section
   - Copy your **API Token** (displayed in the integration details)
   - Document the available API format options

8. **Collect Clear Channel Requirements**
   - Contact Clear Channel scheduling team for technical requirements
   - Determine preferred API format (JSON, XML, HTML, etc.)
   - Gather billboard Location IDs for target inventory
   - Confirm campaign timing and creative specifications

### Step 2: Generate API URLs

Create URLs for each billboard using this format:
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/{format}?api_token={token}&location_id={board_id}
```

#### Available API Formats

**JSON Format** (Most flexible):
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/json?api_token={token}&location_id={board_id}
```

**XML Format** (Traditional RSS/XML systems):
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/xml?api_token={token}&location_id={board_id}
```

**HTML Format** (Web-based players):
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/html?api_token={token}&location_id={board_id}
```

**Direct Image Format** (Simple image delivery):
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/image?api_token={token}&location_id={board_id}
```

**VAST Format** (Video advertising):
```
https://pull.lucit.app/api/v1/campaigns/cco/{hash_id}/pull/vast?api_token={token}&location_id={board_id}
```

### Step 3: Clear Channel Implementation

1. **Provide URLs to Clear Channel Team**
   - Email API URLs to your Clear Channel scheduling contact
   - Include campaign specifications and timing requirements
   - Provide technical contact information for integration support

2. **Coordinate Implementation Timeline**
   - Work with Clear Channel team to schedule implementation
   - Provide testing window for integration validation
   - Confirm go-live timing and campaign activation

3. **Technical Implementation by Clear Channel**
   - Clear Channel technical team implements URLs into their system
   - Integration testing and validation performed
   - Campaign scheduled according to agreed timing

## Troubleshooting

### Common Issues

**Problem**: API endpoints not responding  
**Solution**: 
- Verify campaign is published with configured screens in Lucit
- Check API token validity and URL formatting
- Confirm hash_id is correct from Link Player section
- Test URLs manually in browser for response verification

**Problem**: Integration delays with Clear Channel  
**Solution**:
- Maintain regular communication with Clear Channel scheduling team
- Provide clear technical documentation and contact information
- Allow adequate lead time for Clear Channel internal processes
- Consider Place Exchange alternative for faster implementation

**Problem**: Content not updating on displays  
**Solution**:
- Verify Clear Channel system is polling URLs at appropriate intervals
- Check that location_id parameters match Clear Channel system values
- Confirm campaign updates are published in Lucit
- Coordinate with Clear Channel technical team for troubleshooting

**Problem**: Format compatibility issues  
**Solution**:
- Work with Clear Channel technical team to identify preferred format
- Test multiple format options (JSON, XML, HTML) for compatibility
- Provide sample responses for each format type
- Adjust Lucit output format if needed (contact Lucit support)


## Technical Reference

### URL Parameters
- `{hash_id}`: Campaign identifier from Lucit Link Player
- `{format}`: API response format (json, xml, html, image, vast)
- `{token}`: API authentication token from Lucit Account Settings
- `{board_id}`: Clear Channel Location ID for specific billboard

### Supported Formats
- **JSON**: Structured data format for modern systems
- **XML**: Traditional RSS/XML for legacy systems  
- **HTML**: Complete web page for web-based players
- **IMAGE**: Direct image URL for simple implementations
- **VAST**: Video Ad Serving Template for video content

### Performance Considerations
- **Refresh Rates**: Coordinate with Clear Channel for optimal polling intervals
- **Network Requirements**: Ensure reliable connectivity from Clear Channel systems
- **Scaling**: Each billboard requires unique location_id parameter
- **Monitoring**: Coordinate monitoring and alerting with Clear Channel team

## Related Resources

- [Place Exchange Integration](how-to-schedule-lucit-campaigns-in-place-exchange.md) - Enhanced programmatic option for Clear Channel inventory
- [API Documentation](../../developer/api/index.html) - Complete API endpoint specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Alternative Recommendation

### Consider Place Exchange for Enhanced Capabilities

For Clear Channel inventory, Place Exchange integration provides:
- **Faster Implementation**: Direct programmatic integration
- **Enhanced Features**: Deal linking and advanced targeting
- **Better Control**: Real-time campaign management capabilities
- **Improved Analytics**: Detailed performance tracking and reporting

## Next Steps

1. **Coordinate Implementation**: Work closely with Clear Channel scheduling team for smooth integration
2. **Monitor Performance**: Track API response times and content update frequency
3. **Consider Place Exchange**: Evaluate Place Exchange integration for enhanced capabilities
4. **Support**: Contact your Lucit Account Representative for integration assistance

For additional support with Clear Channel integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.