---
title: "How to Schedule Lucit Campaigns in Daktronics"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Daktronics Venus Control Suite using DPF file generation"
keywords: [lucit, daktronics, venus control suite, integration, digital signage, dynamic campaigns, dpf file]
---

# How to Schedule Lucit Campaigns in Daktronics

## Integration Overview

Daktronics integrates with Lucit through DPF (Daktronics Package File) generation for Venus Control Suite. This integration involves downloading DPF files from Lucit and uploading them to the Daktronics Media Library for scheduling like standard image files.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Daktronics App Installed** - The Daktronics app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Daktronics Venus Control Suite Access** with media library permissions  
✅ **Venus Control Suite GUIDs** for target signs (extracted from Venus URL)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Daktronics App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Daktronics** app appears in your list
   - If not visible, click **ADD NEW** and add the Daktronics app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Daktronics Tab**
   - In the Link Player dialog, locate the **Daktronics** tab
   - If you don't see the Daktronics tab, return to Step 2 to add the app
   - Click on the **Daktronics** tab to view integration options

### Step 2: Extract Venus Control Suite GUIDs

1. **Access Venus Control Suite**
   - Log into your Daktronics Venus Control Suite
   - Navigate to your target digital signs

2. **Extract GUID from URL**
   - Open individual sign management page
   - Copy GUID from URL: `https://venus.daktronics.com/helpers/devices/displayDetails?displayId={GUID}`
   - Example GUID: `13bfcbbe-1830-47cd-92fc-dcbb548e97bd`
   - Document GUID for each target sign

3. **Verify Sign Information**
   - Use Venus API to get sign metadata:
   ```
   https://venus.daktronics.com/helpers/devices/displayDetails?displayId={GUID}
   ```
   - Confirm sign dimensions, controller information, and connectivity status

### Step 3: Download DPF Files

1. **Generate DPF Files in Lucit**
   - In campaign Link Player → Daktronics section
   - Click **Download DPF** for each target sign
   - Files are named: `lucit_{campaign-name}_{hash-id}.dpf`

2. **Verify DPF File Contents**
   - Each DPF file contains campaign-specific dynamic content configuration
   - Files are ready for direct upload to Venus Media Library

### Step 4: Venus Control Suite Implementation

1. **Upload to Media Library**
   - Access **Media Library** in Venus Control Suite
   - Click **Upload Media** or **Add Content**
   - Select and upload each DPF file
   - Files appear as HTML content type in media library

2. **Create Playlists**
   - **Critical Requirement**: Must create playlist with 2+ items
   - Single-item playlists prevent content re-rendering
   - Add DPF file plus at least one other content item
   - Example: Lucit DPF + time/date creative or scheduile 2 different Lucit DPF files

3. **Configure Playlist Settings**
   - Set **Duration** for DPF content (recommend 8-15 seconds)
   - Configure **Duration** for additional playlist items
   - Set **Loop Behavior** for continuous playback
   - Example timing: 10 seconds Lucit + 4 seconds time display = 4+ plays per minute

### Step 5: Schedule Content

1. **Schedule Playlists**
   - Navigate to **Schedule Management** in Venus
   - Create new schedule or modify existing schedule
   - Assign playlist to target signs
   - Configure date ranges and time slots

2. **Activate Schedule**
   - Apply schedule to selected signs
   - Monitor initial deployment for connectivity
   - Verify content begins displaying on target signs

### Step 6: Testing & Validation

1. **Verify Content Loading**
   - Confirm DPF content displays correctly on Venus-connected signs
   - Check that dynamic elements load from Lucit servers
   - Monitor for any rendering or connectivity issues

2. **Test Dynamic Updates**
   - Make changes in Lucit campaign
   - Wait for update cycle (typically 5-15 minutes)
   - Verify changes appear on Daktronics displays

3. **Monitor Performance**
   - Check Venus logs for content loading success/failures
   - Verify consistent refresh rates and content updates
   - Track play frequency and timing accuracy

## Troubleshooting

### Common Issues

**Problem**: DPF files not available for download  
**Solution**: 
- Verify Daktronics application is added to your profile
- Confirm you have appropriate permissions in Lucit account
- Ensure Venus GUIDs are properly configured with Lucit support

**Problem**: Content not rendering after first play  
**Solution**:
- **Critical Fix**: Add second item to playlist (minimum requirement)
- DPF content requires playlist with 2+ items to re-render
- Add time/date creative or other content as second playlist item
- Set appropriate durations for both playlist items

**Problem**: Content not updating dynamically  
**Solution**:
- Verify network connectivity from Venus signs to Lucit servers
- Check that campaign updates are published in Lucit
- Monitor Venus system logs for connection errors
- Confirm DPF refresh intervals are functioning

**Problem**: GUID extraction issues  
**Solution**:
- Verify you have proper access to Venus Control Suite
- Check URL format: `displayDetails?displayId={GUID}`
- Use Venus API to validate GUID format and sign accessibility
- Contact Daktronics support for GUID verification

### Venus API Validation

Test your sign GUIDs using Venus API:
```
https://venus.daktronics.com/helpers/devices/displayDetails?displayId={GUID}
```

Expected response includes:
```json
{
  "id": "sign-guid",
  "name": "Sign Name - Location",
  "height": 80,
  "width": 150,
  "controllerStatuses": [...],
  "isScheduleEnabled": true
}
```

## Technical Reference

### DPF File Structure
- **Format**: Daktronics Package File (.dpf)
- **Content**: HTML package with dynamic content integration
- **Configuration**: Campaign-specific settings and API endpoints
- **Compatibility**: Venus Control Suite Media Library

### Playlist Requirements
- **Minimum Items**: 2+ items required for proper re-rendering
- **Duration Settings**: Must specify duration for each item
- **Loop Behavior**: Configure for continuous playback
- **Content Mix**: DPF file + additional content (time, images, etc.)

### Performance Considerations
- **Refresh Rates**: Typically 5-15 minute intervals for content updates
- **Network Requirements**: Reliable connectivity from signs to Lucit servers
- **Playlist Timing**: Balance DPF duration with other content for optimal play frequency
- **Hardware Compatibility**: Works with Venus-compatible Daktronics displays

## Related Resources

- [Lucit vs Daktronics Comparison](../../compare/lucit-vs-daktronics.md) - Venus Control Suite integration advantages
- [API Documentation](../../developer/api/index.html) - Technical specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Sign Management
- Generate separate DPF files for each sign location
- Use location-specific content through Lucit geo-targeting
- Implement consistent naming conventions for DPF files and playlists

### Performance Optimization
- Monitor play frequency: optimal ~4+ plays per minute
- Adjust playlist timing based on content refresh needs
- Set up Venus monitoring for content delivery performance

## Next Steps

1. **Enable Integration**: Contact Lucit support to enable Daktronics application
2. **GUID Collection**: Extract Venus GUIDs for all target signs
3. **Deploy DPF Files**: Download, upload, and schedule DPF content with proper playlists
4. **Monitor Performance**: Track content delivery and optimize timing
5. **Support**: Contact your Lucit Account Representative for optimization assistance

For additional support with Daktronics integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.