---
title: "How to Schedule Lucit Campaigns in DoohClick"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with DoohClick using multiple API format endpoints"
keywords: [lucit, doohclick, integration, digital signage, dynamic campaigns, api, json, xml]
---

# How to Schedule Lucit Campaigns in DoohClick

## Integration Overview

DoohClick integrates with Lucit through multiple API format endpoints supporting JSON, XML, IMAGE, VAST, and HTML formats. This integration requires coordination with DoohClick's scheduling team who will implement the provided URLs into their player system.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **DoohClick App Installed** - The DoohClick app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **DoohClick Partnership** with scheduling team contact  
✅ **Screen Location IDs** from DoohClick system  
✅ **Preferred API Format** (coordinate with DoohClick technical team)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify DoohClick App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **DoohClick** app appears in your list
   - If not visible, click **ADD NEW** and add the DoohClick app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access DoohClick Tab**
   - In the Link Player dialog, locate the **DoohClick** tab
   - If you don't see the DoohClick tab, return to Step 2 to add the app
   - Click on the **DoohClick** tab to view integration options

7. **Gather Campaign Information**
   - Note the **Campaign Hash ID** displayed in the DoohClick section
   - Copy your **API Token** (displayed in the integration details)
   - Document the available API format options

8. **Collect DoohClick Requirements**
   - Contact DoohClick scheduling team for technical requirements
   - Determine preferred API format (JSON, XML, HTML, etc.)
   - Gather screen Location IDs for target inventory
   - Confirm campaign timing and creative specifications

### Step 2: Generate API URLs

Create URLs for each screen using this format:
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/{format}?api_token={token}&location_id={board_id}
```

#### Available API Formats

**JSON Format** (Most flexible):
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/json?api_token={token}&location_id={board_id}
```

**XML Format** (Traditional RSS/XML systems):
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/xml?api_token={token}&location_id={board_id}
```

**HTML Format** (Web-based players):
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/html?api_token={token}&location_id={board_id}
```

**Direct Image Format** (Simple image delivery):
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/image?api_token={token}&location_id={board_id}
```

**VAST Format** (Video advertising):
```
https://pull.lucit.app/api/v1/campaigns/doohclick/{hash_id}/pull/vast?api_token={token}&location_id={board_id}
```

### Step 3: DoohClick Implementation

1. **Provide URLs to DoohClick Team**
   - Email API URLs to your DoohClick scheduling contact
   - Include campaign specifications and timing requirements
   - Provide technical contact information for integration support

2. **Coordinate Implementation Timeline**
   - Work with DoohClick team to schedule implementation
   - Provide testing window for integration validation
   - Confirm go-live timing and campaign activation

3. **Technical Implementation by DoohClick**
   - DoohClick technical team implements URLs into their system
   - Integration testing and validation performed
   - Campaign scheduled according to agreed timing

### Step 4: Testing & Validation

1. **API Response Testing**
   - Test each format URL to verify proper response structure
   - Confirm location-specific content delivery
   - Validate data format compatibility with DoohClick systems

2. **Example JSON Response**:
   ```json
   {
     "campaign_id": "hash_id",
     "location_id": "board_id", 
     "creative_url": "https://generated-image-url.jpg",
     "updated_at": "2026-01-03T10:00:00Z",
     "expires_at": "2026-01-03T10:15:00Z"
   }
   ```

3. **Coordinate Testing with DoohClick**
   - Work with DoohClick team to verify integration functionality  
   - Test dynamic content updates and refresh timing
   - Confirm display quality and performance on target screens

## Troubleshooting

### Common Issues

**Problem**: API endpoints not responding  
**Solution**: 
- Verify campaign is published with configured screens in Lucit
- Check API token validity and URL formatting
- Confirm hash_id is correct from Link Player section
- Test URLs manually in browser for response verification

**Problem**: Integration delays with DoohClick  
**Solution**:
- Maintain regular communication with DoohClick scheduling team
- Provide clear technical documentation and contact information
- Allow adequate lead time for DoohClick internal processes
- Provide sample API responses for testing

**Problem**: Content not updating on displays  
**Solution**:
- Verify DoohClick system is polling URLs at appropriate intervals
- Check that location_id parameters match DoohClick system values
- Confirm campaign updates are published in Lucit
- Coordinate with DoohClick technical team for troubleshooting

**Problem**: Format compatibility issues  
**Solution**:
- Work with DoohClick technical team to identify preferred format
- Test multiple format options (JSON, XML, HTML) for compatibility
- Provide sample responses for each format type
- Adjust Lucit output format if needed (contact Lucit support)

### API Response Validation

Test your API endpoints using appropriate format:

**JSON Format Response**:
```json
{
  "status": "success",
  "campaign_id": "abc123",
  "location_id": "doohclick_screen_001",
  "creative_url": "https://pull.lucit.app/generated/image.jpg",
  "format": "image/jpeg",
  "updated_at": "2026-01-03T10:00:00Z"
}
```

**XML Format Response**:
```xml
<?xml version="1.0" encoding="UTF-8"?>
<lucit-campaign>
  <campaign-id>abc123</campaign-id>
  <location-id>doohclick_screen_001</location-id>
  <creative-url>https://pull.lucit.app/generated/image.jpg</creative-url>
  <updated-at>2026-01-03T10:00:00Z</updated-at>
</lucit-campaign>
```

## Technical Reference

### URL Parameters
- `{hash_id}`: Campaign identifier from Lucit Link Player
- `{format}`: API response format (json, xml, html, image, vast)
- `{token}`: API authentication token from Lucit Account Settings
- `{board_id}`: DoohClick Location ID for specific screen

### Supported Formats
- **JSON**: Structured data format for modern systems
- **XML**: Traditional RSS/XML for legacy systems  
- **HTML**: Complete web page for web-based players
- **IMAGE**: Direct image URL for simple implementations
- **VAST**: Video Ad Serving Template for video content

### Performance Considerations
- **Refresh Rates**: Coordinate with DoohClick for optimal polling intervals
- **Network Requirements**: Ensure reliable connectivity from DoohClick systems
- **Scaling**: Each screen requires unique location_id parameter
- **Monitoring**: Coordinate monitoring and alerting with DoohClick team

## Related Resources

- [API Documentation](../../developer/api/index.html) - Complete API endpoint specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Screen Management
- Use consistent naming conventions across screens in documentation
- Implement location-specific content using Lucit geo-targeting features
- Set up monitoring for API response performance across screen network

### Performance Monitoring
- Track API response times and content update frequency
- Monitor DoohClick system logs for integration performance
- Set up alerting for feed failures or connectivity issues

## Next Steps

1. **Coordinate Implementation**: Work closely with DoohClick scheduling team for smooth integration
2. **Monitor Performance**: Track API response times and content update frequency
3. **Scale Implementation**: Add additional screens using the established URL format pattern
4. **Support**: Contact your Lucit Account Representative for integration assistance

For additional support with DoohClick integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.