---
title: "How to Schedule Lucit Campaigns in Formetco F360"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Formetco F360 digital signage platform using Live Link technology"
keywords: [lucit, formetco, f360, integration, digital signage, dynamic campaigns, live link]
---

# How to Schedule Lucit Campaigns in Formetco F360

## Integration Overview

Formetco F360 integrates with Lucit through Live Link technology, providing real-time dynamic content capabilities within the F360 platform ecosystem. This integration enables seamless dynamic advertising without manual file management or creative updates.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Formetco F360 App Installed** - The Formetco F360 app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Formetco F360 Access** with content management permissions  
✅ **Live Link Enabled** (contact Apparatix / F360 support if not visible)  
✅ **Contract Prefix Codes** configured with Lucit support team
✅ **APX Player Helper installed on every screen** (contact Apparatix / F360 support for help)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Formetco F360 App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Formetco F360** app appears in your list
   - If not visible, click **ADD NEW** and add the Formetco F360 app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Formetco F360 Tab**
   - In the Link Player dialog, locate the **Formetco F360** tab
   - If you don't see the Formetco F360 tab, return to Step 2 to add the app
   - Click on the **Formetco F360** tab to view integration options

7. **Copy Live Link URL**
   - Find the Live Link URL in the Formetco F360 section
   - Format: `https://pull.lucit.app/api/v1/campaigns/apx/v2/{export.hash_id}/pull/html?api_token={token}&n={account_slug}|{export_slug}`
   - Click **Copy URL** button to clipboard

### Step 2: Formetco F360 Configuration

1. **Access F360 Content Manager**
   - Log into your Formetco F360 dashboard
   - Navigate to **Content Management** section

2. **Create Live Link Content**
   - Click **Add Content** → **Live Link/URL**
   - Paste the copied Lucit URL into the URL field
   - Name the content item (e.g., "Lucit Dynamic - [Campaign Name]")

3. **Configure Content Settings**
   - Set **Refresh Interval**: 60-300 seconds (recommended)
   - Configure **Display Duration** as needed for playlist integration
   - Set **Content Type**: HTML/Web Content
   - Click **Test URL** to verify accessibility

4. **Create and Schedule Playlist**
   - Navigate to **Playlist Management**
   - Create new playlist or select existing playlist
   - Add your Lucit Live Link content to playlist
   - Configure playlist timing and loop settings
   - Apply playlist to target screens/zones through **Schedule Management**

### Step 3: Testing & Validation

1. **Verify Content Loading**
   - Use F360 preview feature to test Live Link content
   - Confirm creative renders correctly within F360 player
   - Check that all dynamic elements display properly

2. **Test Dynamic Updates**
   - Make a change in your Lucit campaign (text, data, or imagery)
   - Wait for configured refresh interval
   - Verify changes appear on F360-connected screens

3. **Monitor System Performance**
   - Check F360 system logs for connection errors
   - Verify consistent refresh rates and content loading
   - Monitor network performance on player devices

## Troubleshooting

### Common Issues

**Problem**: Live Link URL not working  
**Solution**: 
- Verify Lucit campaign is published and screens are configured
- Make sure your screen identifiers match to the screen identifiers in Apparatix
- Make sure that all screen identifiers end in `.1` for instance `MYSCRA.1`
- Confirm Live Link feature is enabled (contact Apparatix support)

**Problem**: Creative not updating  
**Solution**:
- Check refresh interval settings in Apparatix
- Verify internet connectivity on player devices  
- Confirm campaign changes are saved and published in Lucit

**Problem**: Not working on some screens
- Verify that EACH screen in the campaign has the `APX Player Helper` installed
- Verify that the `APX Player Helper` is up and running on each screen
- Verify that the screen identifiers match

**Problem**: Display formatting issues  
**Solution**:
- Verify screen resolution settings match Lucit screen settings for each screen


## Technical Reference

### Live Link URL Structure
```
https://pull.lucit.app/api/v1/campaigns/apx/v2/{export.hash_id}/pull/html
?api_token={token}
&n={account_slug}|{export_slug}
```

### F360 Integration Features
- **Real-time content updates** through Live Link technology
- **Playlist integration** with F360 scheduling system
- **Multi-zone support** for complex screen configurations  
- **Performance monitoring** through F360 analytics dashboard
- **Network optimization** for reliable content delivery

### Performance Optimization
- **Recommended Refresh Rate**: 60-300 seconds for optimal balance
- **Content Caching**: F360 handles local caching for improved performance
- **Network Requirements**: Stable internet connection required for Live Link functionality
- **Resource Management**: Monitor bandwidth usage for large-scale deployments

## Related Resources

- [Lucit vs Formetco Comparison](../../compare/lucit-vs-formetco.md) - Feature comparison and benefits
- [API Documentation](../../developer/api/index.html) - Advanced integration options
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Screen Management
- Configure location-specific content using Lucit's geo-targeting features
- Set up different refresh rates for different content types
- Implement fallback content for network connectivity issues

### Performance Monitoring
- Use F360 analytics to track content performance and loading times
- Monitor Lucit campaign analytics for engagement metrics
- Set up alerting for connection or performance issues

## Next Steps

1. **Scale Implementation**: Apply Live Link integration to additional F360 campaigns and screens
2. **Performance Optimization**: Monitor and adjust refresh rates based on content type and network performance
3. **Advanced Features**: Explore Lucit's location-based content and real-time data integration capabilities
4. **Support**: Contact your Lucit Account Representative for advanced configuration and optimization

For additional support with Formetco F360 integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.