---
title: "How to Schedule Lucit Campaigns in Lamar iSpot"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Lamar iSpot using campaign ID sharing for ScalaScript integration"
keywords: [lucit, lamar, ispot, integration, digital signage, dynamic campaigns, scalascript, campaign id]
---

# How to Schedule Lucit Campaigns in Lamar iSpot

## Integration Overview

Lamar iSpot integrates with Lucit through campaign ID sharing for ScalaScript implementation. The Lamar iSpot technical team uses the provided campaign hash ID to generate custom ScalaScript code that pulls dynamic content directly from Lucit's servers.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Lamar iSpot App Installed** - The Lamar iSpot app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Lamar Partnership** with iSpot technical team contact  
✅ **Digital Market Scheduler Access** (for Lamar team)  
✅ **Target Screen Locations** identified in Lamar system

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Lamar iSpot App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Lamar iSpot** app appears in your list
   - If not visible, click **ADD NEW** and add the Lamar iSpot app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Obtain Campaign ID**
   - Copy the **Campaign Hash ID** (format: lch-xxxx)
   - Note this ID for sharing with Lamar technical team

### Step 2: Coordinate with Lamar Team

1. **Contact Lamar iSpot Technical Team**
   - Provide Campaign Hash ID from Step 1
   - Include campaign timing and creative specifications
   - Confirm target screen locations and scheduling requirements

2. **Lamar Technical Implementation**
   - Lamar team generates custom ScalaScript using provided Campaign ID
   - ScalaScript programmed to pull content from Lucit servers
   - Integration tested on target screens


### Step 3: ScalaScript Implementation

1. **Script Generation by Lamar**
   - Lamar technical team creates ScalaScript incorporating Lucit Campaign ID
   - Script configured for dynamic content pulling
   - Integration code customized for specific screen requirements

2. **Digital Market Scheduler Deployment**
   - Lamar team uploads ScalaScript to Digital Market Scheduler
   - Script scheduled according to campaign timing requirements
   - Deployment activated across target screen locations

### Step 4: Testing & Validation

1. **Initial Testing**
   - Lamar team tests ScalaScript functionality on test screens
   - Verify dynamic content loads correctly from Lucit
   - Confirm screen formatting and display quality

2. **Campaign Validation**
   - Monitor campaign launch across target screens
   - Verify dynamic content updates are reflected
   - Confirm scheduling timing matches requirements

3. **Performance Monitoring**
   - Track content delivery and update frequency
   - Monitor screen performance and connectivity
   - Coordinate any needed adjustments with Lamar team

## Troubleshooting

### Common Issues

**Problem**: Campaign ID not working  
**Solution**: 
- Verify campaign is published and active in Lucit
- Check that Campaign Hash ID is correctly copied (format: lch-xxxx)
- Ensure campaign has screens configured and assigned
- Contact Lucit support to verify campaign API accessibility

**Problem**: ScalaScript not pulling content  
**Solution**:
- Coordinate with Lamar technical team to check script implementation
- Verify network connectivity from Lamar screens to Lucit servers
- Test Campaign ID manually using Lucit API endpoints
- Check for firewall or network restrictions on Lamar systems

**Problem**: Content not updating dynamically  
**Solution**:
- Verify campaign updates are published in Lucit
- Check ScalaScript refresh intervals with Lamar team
- Confirm script is actively running on target screens
- Monitor network stability and content delivery timing

**Problem**: Display formatting issues  
**Solution**:
- Verify screen format settings in Lucit campaign match Lamar displays
- Coordinate with Lamar team on screen resolution and aspect ratio requirements
- Test content rendering on various screen types
- Adjust Lucit template settings if needed

### Campaign ID Validation

Your Campaign Hash ID should follow this format:
```
lch-[alphanumeric-string]
```

Example: `lch-4Ccv2XyZ`

You can verify your Campaign ID works by testing this URL structure:
```
https://layout.lucit.cc/api/v1/campaigns/[campaign-hash-id]/pull
```

## Technical Reference

### Campaign ID Integration
- **Format**: Campaign Hash ID (lch-xxxx format)
- **Usage**: Incorporated into ScalaScript for dynamic content pulling
- **Endpoint**: Lucit API endpoints accessed via ScalaScript
- **Refresh**: Configurable through ScalaScript implementation

### ScalaScript Implementation
- **Custom Development**: Lamar team creates campaign-specific scripts
- **Dynamic Content**: Real-time pulling from Lucit servers
- **Screen Compatibility**: Optimized for Lamar display hardware
- **Scheduling Integration**: Works with Digital Market Scheduler system

### Performance Considerations
- **Network Requirements**: Reliable internet connectivity from screens to Lucit
- **Refresh Rates**: Configured in ScalaScript based on content type
- **Screen Compatibility**: Optimized for Lamar's specific hardware configurations
- **Monitoring**: Performance tracking through Lamar system monitoring

## Related Resources

- [API Documentation](../../developer/api/index.html) - Technical specifications for API endpoints
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Location Campaigns
- Single Campaign ID can serve multiple screen locations
- Location-specific content using Lucit geo-targeting features
- Coordinated rollouts across multiple markets

### Performance Optimization
- Work with Lamar team to optimize ScalaScript refresh rates
- Monitor content delivery performance across screen network
- Implement fallback content for network connectivity issues

## Next Steps

1. **Coordinate Implementation**: Work with Lamar iSpot technical team for ScalaScript development
2. **Monitor Performance**: Track campaign performance and content delivery across screens
3. **Scale Implementation**: Apply successful integration patterns to additional campaigns
4. **Support**: Contact your Lucit Account Representative for campaign optimization assistance

For additional support with Lamar iSpot integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.