---
title: "How to Schedule Lucit Campaigns in LDSK Player"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with LDSK Player using HTML5 package generation with postMessage lifecycle"
keywords: [lucit, ldsk, livedooh signkick, integration, digital signage, dynamic campaigns, html5, postmessage]
---

# How to Schedule Lucit Campaigns in LDSK Player

## Integration Overview

LDSK (LiveDOOH Signkick) Player integrates with Lucit through HTML5 package generation with advanced postMessage lifecycle communication. This integration creates downloadable ZIP packages optimized for LDSK's HTML5 creative requirements and postMessage event system.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **LDSK App Installed** - The LDSK app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **LDSK Player Access** with content upload and scheduling permissions  
✅ **LDSK Player Version 15.1+** (required for HTML5 creative support)  
✅ **Target Screen Configurations** for package optimization

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify LDSK App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **LDSK** app appears in your list
   - If not visible, click **ADD NEW** and add the LDSK app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access LDSK Tab**
   - In the Link Player dialog, locate the **LDSK** tab
   - If you don't see the LDSK tab, return to Step 2 to add the app
   - Click on the **LDSK** tab to view integration options

7. **Prepare Integration Requirements**
   - Document target LDSK player locations and screen specifications
   - Confirm LDSK player versions meet HTML5 requirements (15.1+)

### Step 2: Configure HTML Package Settings

1. **Access LDSK Configuration**
   - In LDSK section of Link Player, configure package settings
   - **Error Handling Mode**: Choose silent vs error display for troubleshooting
   - **Debug Options**: Enable enhanced logging and on-screen debugging
   - **Fallback Content**: Configure account default creative for network failures

2. **Advanced Configuration Options**
   - **Geographic Targeting**: Set location-specific content preferences
   - **Refresh Rates**: Configure creative update intervals
   - **Network Fallback**: Configure behavior for connectivity issues
   - **Player Communication**: Set up postMessage event handling preferences

### Step 3: Generate HTML Package

1. **Download Package**
   - Click **Generate HTML Package** in LDSK section
   - System creates customized ZIP file with LDSK-optimized components

2. **Package Verification**
   - Verify ZIP contains all required files
   - Check that `index.html` is at root level (LDSK requirement)
   - Confirm JavaScript compatibility for Tizen Samsung machines

### Step 4: LDSK Player Implementation

1. **Upload HTML Package**
   - Access LDSK content management interface
   - Upload ZIP package to LDSK player system
   - System extracts package to local file system
   - Verify `index.html` is recognized as starting point

2. **Configure Content Settings**
   - Set content type to HTML5/Web Content
   - Configure display duration and refresh settings
   - Set up inventory mapping for location-specific content
   - Enable postMessage communication if required

3. **Schedule Content**
   - Create playlist or add to existing playlist
   - Schedule HTML content according to campaign requirements
   - Apply to target screens with LDSK Player 15.1+ compatibility

### Step 5: Testing & Validation

1. **Package Compatibility Testing**
   - Verify HTML5 features work on target LDSK player versions
   - Test JavaScript compatibility (avoid ES6+ for Tizen Samsung machines)
   - Confirm postMessage communication functions correctly

2. **Dynamic Content Validation**
   - Test content loading from Lucit servers
   - Verify location-specific content delivery using inventory data
   - Test fallback content display during network issues

3. **PostMessage Event Testing**
   - Confirm PLAYER_CONFIGURATION events are received 6 seconds before play
   - Test PLAY event triggers correct content display
   - Validate inventory data processing and location targeting

## Troubleshooting

### Common Issues

**Problem**: HTML package not recognized by LDSK  
**Solution**: 
- Verify `index.html` file is at root level of ZIP (not in subfolder)
- Check that LDSK player version is 15.1+ for HTML5 support
- Confirm ZIP archive format is compatible with LDSK extraction
- Verify no compiled files require additional dependencies

**Problem**: JavaScript compatibility errors on Tizen Samsung  
**Solution**:
- This package will not work on these specific, older screens

**Problem**: Content not updating dynamically  
**Solution**:
- Verify network connectivity from LDSK players to Lucit servers
- Check API token validity in settings.js configuration
- Confirm campaign updates are published in Lucit
- Test API endpoints manually for accessibility

### Browser Compatibility Requirements

#### Required for LDSK Compatibility:
- **JavaScript**: ES5 compatible (no ES6+ for Tizen Samsung)
- **HTML5**: Full HTML5 support required
- **CSS**: Standard CSS3 features
- **PostMessage API**: Essential for LDSK communication
- **Event Listeners**: Standard DOM event handling

#### Avoid on Tizen Samsung Machines:
- ES6+ JavaScript features (arrow functions, let/const, etc.)
- Modern JavaScript APIs not supported in older browsers
- CSS features requiring cutting-edge browser support

## Technical Reference

### LDSK HTML5 Requirements
- **Player Version**: 15.1 minimum for HTML5 creative support
- **File Structure**: `index.html` at ZIP root level (required)
- **Browser Engine**: Built-in browser with HTML5 support
- **PostMessage**: Required for player communication
- **Network**: Internet connectivity for dynamic content

### Performance Considerations
- **JavaScript Compatibility**: ES5 compilation for maximum compatibility
- **Network Requirements**: Reliable connectivity for dynamic content updates
- **Content Size**: Optimize for faster loading and better performance
- **Fallback Handling**: Robust error handling for network issues

## Related Resources

- [API Documentation](../../developer/api/index.html) - Technical specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines  
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### PostMessage Communication
- Implement custom inventory data processing
- Configure location-based content strategies
- Set up advanced player communication patterns

### Performance Optimization  
- Optimize JavaScript for Tizen Samsung compatibility
- Implement efficient content loading and caching
- Configure appropriate refresh rates for content type

### Error Handling
- Set up comprehensive fallback content strategies
- Implement debug modes for troubleshooting
- Configure network failure handling and recovery

## Next Steps

1. **Configure Package**: Set up LDSK-specific configuration options in Lucit
2. **Generate Package**: Download HTML5 package optimized for LDSK requirements
3. **Deploy Content**: Upload to LDSK players and test postMessage communication
4. **Monitor Performance**: Track content delivery and player communication
5. **Support**: Contact your Lucit Account Representative for optimization assistance

For additional support with LDSK Player integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.