---
title: "How to Schedule Lucit Campaigns in Place Exchange"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Place Exchange using deal ID linking and HTML package generation"
keywords: [lucit, place exchange, integration, digital signage, dynamic campaigns, deal id, html package, programmatic]
---

# How to Schedule Lucit Campaigns in Place Exchange

## Integration Overview

Place Exchange integrates with Lucit through a dual system: Deal ID linking for programmatic campaign association and HTML package generation for direct deployment. This integration combines programmatic advertising capabilities with dynamic creative delivery, providing comprehensive SSP integration.

## Prerequisites

✅ **Lucit Account** with published campaign  
✅ **Place Exchange SSP Access** with deal management permissions  
✅ **Campaign Hash ID** from Lucit Link Player section  
✅ **Place Exchange Deal IDs** from programmatic campaigns  
✅ **API Token** from Lucit Account Settings  
✅ **Target Screen Configurations** for HTML package deployment
✅ **Place Exchange App Added** Ensure that you have added the Place Exchange app under `Apps * Data` section of your account

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Access Campaign Management**
   - Navigate to your published Lucit campaign
   - Click **Link Player** from the `3-dots` icon on the top-right of the campaign
   - Locate **Place Exchange** section

### Step 2: Deal ID Linking System

1. **Add Deal IDs in Lucit**
   - In Place Exchange section, click **Add Deal ID**
   - Enter Place Exchange Deal ID from your programmatic campaign
   - System validates and prevents duplicate deal IDs across campaigns
   - Monitor creation timestamps and status tracking

2. **Manage Deal Associations**
   - View existing deal ID mappings in organized grid
   - Edit or remove associations as needed
   - System provides conflict detection for duplicate deals
   - Track last communication and status updates

### Step 3: HTML Package Generation

1. **Configure Package Settings**
   - **Geographic Targeting**: Set specificity and precision levels
   - **Refresh Rates**: Configure creative refresh intervals
   - **Player Settings**: API tokens and authentication configuration
   - **Fallback Content**: Default creative for network issues

2. **Generate Downloadable Package**
   - Click **Generate HTML Package** in Place Exchange section
   - System creates customized ZIP file with all components
   - Package includes JavaScript-based creative loader with impression tracking

### Step 4: HTML Package Components

The generated package includes what is needed for PX to render the Lucit Creatives.

### Step 5: Testing & Validation

1. **Deal ID Integration Testing**
   - Verify Deal IDs are correctly associated in Lucit
   - Confirm programmatic campaigns pull dynamic content
   - Test location-specific content delivery

2. **HTML Package Validation**
   - Test package locally with location parameters
   - Verify dynamic content loading and impression tracking
   - Confirm fallback content displays during network issues

3. **Geographic Targeting Testing**
   - Verify location-based content customization
   - Test geographic precision and specificity settings
   - Confirm real-time location data integration

## Troubleshooting

### Common Issues

**Problem**: Deal ID conflicts or duplicates  
**Solution**: 
- Check that Deal ID isn't already associated with another campaign
- Verify Deal ID format matches Place Exchange system requirements
- Remove duplicate associations and re-add with correct ID
- Contact Place Exchange support to verify Deal ID validity

**Problem**: HTML package not loading content  
**Solution**:
- Verify all package components are included in ZIP file
- Check settings.js configuration for correct API tokens
- Test package locally with location_id parameters
- Confirm network connectivity from deployment location to Lucit servers

**Problem**: Geographic targeting not working  
**Solution**:
- Verify geographic settings configuration in package generation
- Check that location data is properly passed to HTML package
- Test with different geographic precision levels
- Confirm Place Exchange system passes location parameters correctly

**Problem**: Impression tracking issues  
**Solution**:
- Verify impression tracking code is included in HTML package
- Check that tracking pixels fire correctly during content display
- Test with Place Exchange macros for proper parameter substitution
- Coordinate with Place Exchange team for tracking implementation

### Package Testing

Test HTML packages locally:
1. **Setup Local Environment**: Use local web server for testing
2. **Add Location Parameters**: `?location_id=TEST_LOCATION&lat=40.7128&lon=-74.0060`
3. **Verify Content Loading**: Confirm dynamic content displays correctly
4. **Test Geographic Features**: Validate location-based content customization

## Technical Reference

### Deal ID Management
- **Validation**: System prevents duplicate Deal IDs across campaigns
- **Tracking**: Creation timestamps and communication logging
- **Conflict Detection**: Automatic duplicate prevention
- **Status Monitoring**: Real-time status updates and management

### HTML Package Features
- **Dynamic Loading**: Real-time content pulling with JavaScript
- **Impression Tracking**: Integrated analytics and reporting
- **Geographic Targeting**: Location-based content customization
- **Fallback System**: Robust error handling and default content
- **Responsive Design**: Automatic sizing for various screen formats

### Configuration Options
- **Refresh Rates**: Configurable creative update intervals
- **Geographic Precision**: Adjustable location targeting accuracy
- **API Configuration**: Flexible authentication and endpoint settings
- **Error Handling**: Comprehensive fallback and retry logic

## Related Resources

- [Lucit vs Place Exchange Comparison](../../compare/lucit-vs-place-exchange.md) - Programmatic + dynamic creative combination benefits
- [API Documentation](../../developer/api/index.html) - Technical specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Deal Campaign Management
- Associate multiple Deal IDs with single Lucit campaign
- Coordinate programmatic and direct inventory strategies
- Implement deal-specific content customization

### Geographic Optimization
- Configure location-based content strategies
- Optimize geographic precision for performance
- Implement real-time location data integration

### Performance Monitoring
- Track deal performance in Place Exchange reporting
- Monitor HTML package delivery and performance
- Optimize refresh rates based on content type and network performance

## Next Steps

1. **Choose Integration Method**: Decide between Deal ID linking, HTML packages, or combined approach
2. **Configure Settings**: Set up geographic targeting and refresh rate preferences  
3. **Deploy Integration**: Implement chosen approach with appropriate testing
4. **Monitor Performance**: Track campaign performance across both programmatic and direct inventory
5. **Support**: Contact your Lucit Account Representative for optimization assistance

For additional support with Place Exchange integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.