---
title: "How to Schedule Lucit Campaigns in Vistar Media"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Vistar Media using insertion order linking and HTML package submission"
keywords: [lucit, vistar media, integration, digital signage, dynamic campaigns, insertion order, html package, programmatic]
---

# How to Schedule Lucit Campaigns in Vistar Media

## Integration Overview

Vistar Media integrates with Lucit through a dual approach: Insertion Order ID linking for campaign association and HTML package submission to Vistar support for technical implementation. This programmatic integration enables dynamic creative capabilities within Vistar's DSP platform.

## Prerequisites

✅ **Lucit Account** with published campaign  
✅ **Vistar Media DSP Access** with campaign management permissions  
✅ **Campaign Hash ID** from Lucit Link Player section  
✅ **Vistar Insertion Order IDs** from existing campaigns  
✅ **Vistar Support Contact** for HTML package submission  
✅ **API Token** from Lucit Account Settings
✅ **Vistar Media App Added** Ensure that under `Apps & Data` that the Vistar Media App has been added to your account.

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Access Campaign Management**
   - Navigate to your published Lucit campaign
   - Click **Link Player** from the `3-dots` icon on the top-right of the campaign
   - Locate **Vistar** section
   - Note **Campaign Hash ID** for package generation

2. **Prepare Integration Data**
   - Copy **API Token** from Account Settings → API Access
   - Document target venue IDs from Vistar campaign setup
   - Confirm campaign timing and creative specifications

### Step 2: Link Insertion Order IDs

1. **Add Insertion Order IDs in Lucit**
   - In Vistar section of Link Player, click **Add Insertion Order ID**
   - Enter Vistar Insertion Order ID from your DSP campaign
   - System validates and stores the association
   - Add multiple IDs if campaign spans multiple insertion orders

2. **Manage Insertion Order Associations**
   - View existing insertion order mappings
   - Edit or remove associations as needed
   - System prevents duplicate ID usage across campaigns
   - Monitor creation timestamps and communication tracking

### Step 3: Generate HTML Package

1. **Package Components**
   The Vistar HTML package includes:
   - **`index.html`**: Main execution file for Vistar rendering service
   - **`settings.js`**: Configuration with API token and campaign settings
   - **`style.css`**: Creative styling and formatting
   - **`lucit.js`**: Lucit connectivity and content pulling code
   - **`fallback.jpg`**: Default creative for network/error conditions

2. **Settings Configuration**
   ```javascript
   // settings.js structure
   {
     "api_token": "vistar-media-api-player-token",
     "campaign_id": "lch-campaign-hash-id",
     "default_play_duration": 15,
     "fetch_url": "https://pull.lucit.app/api/v1/campaigns/vistar/{CAMPAIGN_ID}/pull?api_token={API_TOKEN}&location_id={VENUE_ID}",
     "debug_mode": false,
     "fire_playback_report": true
   }
   ```

### Step 4: Submit Package to Vistar Support

1. **Prepare Submission Email**
   Use this template for Vistar support submission:

   ```
   To: msp@vistarmedia.com
   CC: Vistar Support <support@vistarmedia.com>
   Subject: Lucit - Dynamic Creative - [Campaign Name]

   Please add the attached dynamic creative to the following campaign in the Vistar DSP:

   Vistar Campaign Details:
   - Campaign Name: [Campaign Name]
   - Insertion Order ID: [IO-ID]
   - Campaign URL: [Vistar DSP Campaign URL]

   Dynamic Creative:
   - ZIP Package: [Attached or Drive Link]
   - Campaign Hash ID: [lch-xxxxx]
   - Testing Requirements: [Any specific testing needs]

   Technical Contact: [Your technical contact for integration questions]
   ```

2. **Package Submission**
   - Attach HTML package ZIP file to email
   - Include all technical specifications and requirements
   - Provide Lucit technical contact for integration support
   - Request confirmation of successful implementation

### Step 5: Vistar Implementation

1. **Vistar Technical Processing**
   - Vistar support team receives and processes HTML package
   - Package integrated into specified DSP campaign
   - Dynamic creative configured for venue-specific content delivery

2. **Campaign Activation**
   - Vistar activates dynamic creative within DSP campaign
   - Content begins serving according to campaign targeting and budget
   - Dynamic content pulls from Lucit servers in real-time

### Step 6: Testing & Validation

1. **Verify Package Functionality**
   - Test HTML package locally using venue ID parameters
   - URL format for testing: `http://localhost:port/?venue_id=VENUE_ID`
   - Confirm dynamic creative loads and displays correctly

2. **Monitor Campaign Performance**
   - Track campaign performance in Vistar DSP
   - Verify dynamic content updates appear correctly
   - Monitor impression tracking and delivery metrics

3. **Validate Dynamic Updates**
   - Make changes in Lucit campaign
   - Verify updates appear in Vistar-served inventory
   - Test venue-specific content delivery

## Troubleshooting

### Common Issues

**Problem**: Insertion Order ID conflicts  
**Solution**: 
- Check that ID isn't already associated with another Lucit campaign
- Verify Insertion Order ID format matches Vistar system
- Remove duplicate associations and re-add with correct ID
- Contact Vistar support to verify IO ID accuracy

**Problem**: HTML package not working in Vistar  
**Solution**:
- Verify all required files are included in ZIP package
- Check settings.js configuration for correct API token and campaign ID
- Test package locally with venue_id parameter before submission
- Coordinate with Vistar support for package integration issues

**Problem**: Impression tracking not working  
**Solution**:
- Verify tracking pixel URL includes proper Vistar macros
- Check that impression tracking is enabled in settings.js
- Coordinate with Vistar support for macro implementation
- Test tracking URL with sample venue and display parameters

**Problem**: Venue-specific content not displaying  
**Solution**:
- Verify venue_id parameters are correctly passed in Vistar system
- Check that Lucit campaign has venue-specific content configured
- Test API endpoint manually with venue ID parameters
- Coordinate with Vistar support for venue ID implementation

### Package Testing

Test your HTML package locally:
1. **Setup Local Server**: `npm install -g serve && serve`
2. **Add Venue Parameter**: `http://localhost:port/?venue_id=TEST_VENUE`
3. **Verify Response**: Check dynamic content loads correctly
4. **Debug Mode**: Enable debugging in settings.js for troubleshooting

### Vistar Rendering Service Integration

The package interfaces with Vistar's rendering service through specific div IDs:

- **`dynamic-creative-ready`**: Signals creative is ready for snapshot
- **`dynamic-creative-skip`**: Indicates error condition, use fallback

## Technical Reference

### HTML Package Architecture
- **Rendering Integration**: Interfaces with Vistar rendering service
- **Dynamic Content**: Real-time pulling from Lucit servers
- **Venue Targeting**: Location-specific content delivery
- **Impression Tracking**: Integrated analytics and reporting

### API Integration
- **Endpoint**: Vistar-specific API endpoints with venue parameters  
- **Authentication**: Vistar Media API player tokens
- **Content Format**: JSON/HTML response with venue-specific content
- **Tracking**: Impression pixel integration with Vistar macros

### Performance Considerations
- **Rendering Timing**: Optimized for Vistar rendering service requirements
- **Network Requirements**: Reliable connectivity for real-time content pulling
- **Venue Targeting**: Efficient venue-specific content delivery
- **Fallback Handling**: Robust error handling and fallback creative display

## Related Resources

- [Lucit vs Vistar Media Comparison](../../compare/lucit-vs-vistar-media.md) - Enhanced programmatic creative capabilities
- [API Documentation](../../developer/api/index.html) - Technical specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Campaign Management
- Link multiple insertion order IDs to single Lucit campaign
- Manage venue-specific content through Lucit geo-targeting
- Coordinate with Vistar support for complex campaign structures

### Performance Optimization
- Monitor impression delivery and creative performance in Vistar DSP
- Optimize content refresh rates based on campaign performance
- Implement venue-specific content strategies for maximum relevance

## Next Steps

1. **Link Insertion Orders**: Add Vistar Insertion Order IDs in Lucit Link Player
2. **Generate Package**: Create HTML package with proper configuration
3. **Submit to Vistar**: Email package to Vistar support using provided template
4. **Monitor Performance**: Track campaign performance and dynamic content delivery
5. **Support**: Contact your Lucit Account Representative for optimization assistance

For additional support with Vistar Media integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.