---
title: "How to Schedule Lucit Campaigns in Watchfire Ignite"
description: "Step-by-step guide for integrating Lucit dynamic campaigns with Watchfire Ignite using XML feeds with SSL options and hardware compatibility"
keywords: [lucit, watchfire, ignite, integration, digital signage, dynamic campaigns, xml feed, ssl]
---

# How to Schedule Lucit Campaigns in Watchfire Ignite

## Integration Overview

Watchfire Ignite integrates with Lucit through XML feeds with multiple URL options to support different hardware configurations and SSL requirements. This integration provides flexible dynamic content delivery compatible with both newer and legacy Watchfire hardware.

## Important Note on Analytics

Watchfire Integrations are Legacy integrations and do NOT support play and impression reporting within Lucit.   This integration only allows the Watchfire Player to display the dynamic creatives.

## Prerequisites

✅ **Lucit Operator Profile** - You must have access to an Operator Profile in Lucit  
✅ **Watchfire Ignite App Installed** - The Watchfire Ignite app must be added to your Operator Profile (`Settings -> Apps & Data -> ADD NEW`)  
✅ **Lucit Campaign** with at least one screen configured  
✅ **Watchfire Ignite Access** with content management and scheduling permissions  
✅ **Sign Location IDs** from Watchfire system  
✅ **Hardware Information** (to determine appropriate URL format)

## Step-by-Step Integration

### Step 1: Lucit Configuration

1. **Switch to Operator Profile**
   - Click on the Profile Drop-Down in the top-right corner of Lucit
   - Select your **Operator Profile** from the list
   - Verify you see the Operator menu items on the left sidebar

2. **Verify Watchfire Ignite App is Installed**
   - Navigate to **Settings -> Apps & Data**
   - Confirm the **Watchfire Ignite** app appears in your list
   - If not visible, click **ADD NEW** and add the Watchfire Ignite app

3. **Access Campaign Management**
   - From your Operator Profile, navigate to **Campaigns** in the left sidebar
   - Locate your target campaign in the list

4. **Activate Campaign (if needed)**
   - If the campaign shows as **Draft** status, click on the campaign
   - Click the **ACTIVATE** button to make the campaign active
   - Confirm campaign is now in active/running state

5. **Open Link Player Dialog**
   - From the Campaigns list, click on your campaign name
   - Click **LINK PLAYER** button
   - The Link Player dialog will open showing available integrations

6. **Access Watchfire Ignite Tab**
   - In the Link Player dialog, locate the **Watchfire Ignite** tab
   - If you don't see the Watchfire Ignite tab, return to Step 2 to add the app
   - Click on the **Watchfire Ignite** tab to view integration options

### Step 2: Collect Watchfire Location Data

1. **Gather Sign Information from Watchfire Ignite**
   - Log into your Watchfire Ignite system
   - Gather **Location IDs** for each target sign
   - Document hardware types/ages for URL format selection
   - Verify screen resolutions match Lucit campaign settings

### Step 3: Choose Integration URL Format

Watchfire supports three URL formats based on hardware and SSL requirements:

#### Option A: Secure HTTPS (Recommended for newer hardware)
```
https://pull.lucit.app/api/v1/campaigns/watchfire/{hash_id}/pull/xml?api_token={token}&location_id={board_id}
```

#### Option B: HTTP with SSL Images (For mixed environments)
```
http://layout.lucit.cc/api/v1/campaigns/watchfire/{hash_id}/pull/xml?api_token={token}&non_ssl_image_links=1&location_id={board_id}
```

#### Option C: Direct Image URL (For basic implementations)
```
http://layout.lucit.cc/api/v1/campaigns/watchfire/{hash_id}/pull/img?api_token={token}&location_id={board_id}
```

### Step 4: Watchfire Ignite Configuration

1. **Access Content Management**
   - Log into Watchfire Ignite control panel
   - Navigate to **Content Library** or **Dynamic Content** section

2. **Create Dynamic Content Item**
   - Click **Add Content** → **Dynamic/RSS Feed** or **XML Feed**
   - Name the content: "Lucit Dynamic - [Campaign Name] - [Location]"

3. **Configure XML Feed Settings**
   - **Feed URL**: Enter appropriate URL format from Step 3
   - Replace `{hash_id}` with your campaign hash ID
   - Replace `{token}` with your API token
   - Replace `{board_id}` with specific Watchfire Location ID

4. **Set Feed Parameters**
   - **Refresh Interval**: 5-15 minutes (adjust based on content type)
   - **Timeout**: 30-60 seconds
   - **Retry Logic**: Enable automatic retry on failures
   - **Caching**: Enable local caching if available

5. **Test Feed Connection**
   - Use Watchfire's **Test Feed** feature to verify connectivity
   - Confirm XML response structure is properly parsed
   - Check that images load correctly in preview

### Step 4: Schedule Content

1. **Create Playlist**
   - Navigate to **Playlist Management**
   - Create new playlist or add to existing playlist
   - Add your Lucit dynamic content item to playlist

2. **Configure Display Settings**
   - Set **Display Duration**: Based on content refresh needs
   - Configure **Transition Effects**: As desired
   - Set **Loop Behavior**: Continuous for dynamic content

3. **Apply Schedule**
   - Navigate to **Schedule Management**
   - Assign playlist to target signs/groups
   - Configure date ranges and time slots
   - Activate schedule for selected signs

## Troubleshooting

### Common Issues

**Problem**: SSL certificate errors on older hardware  
**Solution**: 
- Switch to HTTP URL format (Option B or C)
- Use `non_ssl_image_links=1` parameter for mixed SSL environments
- Contact Watchfire support for hardware SSL capability verification

**Problem**: XML parsing errors  
**Solution**:
- Verify URL format matches Watchfire XML parser expectations
- Check that hash_id and API token are correctly formatted
- Test feed URL manually to verify valid XML response structure

**Problem**: Images not displaying  
**Solution**:
- Confirm image URLs in XML are accessible from Watchfire hardware
- Check network connectivity from signs to Lucit servers
- Verify image formats are supported by Watchfire players
- Test direct image URL format (Option C) for basic connectivity

**Problem**: Inconsistent refresh timing  
**Solution**:
- Verify refresh interval settings in Watchfire content configuration
- Check that location_id parameters are unique for each sign
- Monitor network stability and feed response times
- Adjust timeout settings based on network performance

### Hardware Compatibility Guide

**Newer Watchfire Hardware (2018+)**:
- Use HTTPS URL format (Option A)
- Full SSL support available
- Fastest performance and security

**Mixed Hardware Environments**:
- Use HTTP with SSL images (Option B)
- Balances compatibility and performance
- Recommended for most deployments

**Legacy Hardware (Pre-2015)**:
- Use direct image format (Option C)
- Basic functionality only
- Consider hardware upgrade for full dynamic capabilities

## Technical Reference

### URL Parameter Details
- `{hash_id}`: Campaign identifier from Lucit Link Player
- `{token}`: API authentication token from Lucit Account Settings
- `{board_id}`: Watchfire Location ID for specific sign
- `non_ssl_image_links=1`: Forces HTTP image URLs for SSL compatibility

### Performance Optimization
- **Recommended Refresh**: 5-15 minutes based on content type
- **Image Optimization**: Use appropriate image sizes for sign resolution
- **Network Requirements**: Stable internet connection with adequate bandwidth
- **Caching**: Enable Watchfire local caching when available

## Related Resources

- [Lucit vs Watchfire Ignite Comparison](../../compare/lucit-vs-watchfire-ignite.md) - Feature benefits and XML integration advantages
- [API Documentation](../../developer/api/index.html) - XML feed technical specifications
- [Screen Format Reference](../screen-format-reference.md) - Display configuration guidelines  
- [Integration Hub](index.md) - Other player integration guides

## Advanced Configuration

### Multi-Sign Management
- Use consistent naming conventions for content items across signs
- Implement location-specific content using Lucit geo-targeting
- Set up monitoring for feed performance across sign network

### Performance Monitoring
- Monitor feed success rates and response times in Watchfire logs
- Track content update frequency and display performance
- Set up alerting for feed failures or connectivity issues

## Next Steps

1. **Scale Implementation**: Configure additional signs using appropriate URL formats for each hardware type
2. **Performance Optimization**: Monitor and adjust refresh intervals based on content type and network performance
3. **Hardware Assessment**: Evaluate older hardware for potential upgrades to support full SSL capabilities
4. **Support**: Contact your Lucit Account Representative for advanced configuration assistance

For additional support with Watchfire Ignite integration, contact your Lucit Account Representative or submit a support ticket through the Lucit platform.