---
title: "Post Ad Navigation Guide"
description: "List of various navigation steps the Post Ad workflow in Lucit"
keywords: "ui, user interface, navigation, lucit"
---

# Post Ad Navigation Guide

## Overview

The purpose (or goal) of the "Post Ad" process is to create an ad that will run on a digital billboard / screen or digital signage.

## Prerequisites

This process requires that you have

* A Lucit Account
* A Campaign attached to 1 or more screens
* Permission to post ads to your account
* An ad (in JPEG or PNG Format) that you want to post, OR, a template that you have designed in `Templates`. See the [Template Designer General Navigation Guide](template-designer-general-navigation-guide.md) to learn how to create templates.

## How to Start Posting an Ad

The post ad process begins by clicking the `POST AD` button.  This button is available in a number of places in the Lucit Interface, including :

* `Account Profile -> Home Page - POST AD`
* `Account Profile -> Campaigns -> {Campaign} Page -> POST AD`
* `Account Profile -> Templates -> {Template}  -> POST AD`

## Post Ad Workflow Overview

```
POST AD Button
    ↓
Choose Creative Type
    ├─→ Complete Creative → Upload Images → Crop/Stretch → Generate
                    ↓
                Proof Page
    └─→ Dynamic Template → Fill Template Fields → Generate
                ↓
            Proof Page
```

## Detailed Post Ad Workflow

After clicking POST AD, you will be presented with a series of steps.  These are outlined below

* **What do you want to post? Dialog**
    * **Complete Creative** Option
        * Choose this option when you have already designed an ad and you have made versions of this ad in each size required for your campaign
        * Your ads should be in JPG format for best results, but PNG is also supported
    * **Dynamic Template** Option
    * **CANCEL** Button
    * **NEXT** Button
    * *Complete Creative*
        * IF campaign has just 1 screen size
            * User is Presented with a `Click Here To Upload Size {width}x{height}`
            * Click on this text to open up your file choose
            * Select a file that is (or close to) that size
            * User will then be shown a Cropping Window.  Crop on the `CROP` tab, or, using the `STRETCH` tab, stretch the image to fit the screen size
            * Click `CREATE`
            * Your ad will be generated, and you will land on the **Proof Page** for this creative.
        * IF campaign has multiple different screen sizes
            * User is presented with a list of each different screen size {width}x{height}
            * Click on ONE of the screen sizes to upload your creative
            * `CROP` or `STRETCH` your image to fit
            * Click `CREATE`
            * Your ad will be generated in ALL sizes automatically based on your upload and you will land on the **Proof Page** for this creative
            * On the **Proof Page** click the `EDIT` button to edit the sizes for this creative (The **Item Page**)
            * Next to each image that is squished or distorted (wrong size) click on the `CHANGE THIS IMAGE` button to upload a new image that best fits that size
            * Once complete (uploading each image size) click on the `VIEW PROOF` button to return to the **Proof Page**
    * *Dynamic Template*
        * From the list of templates in your account, choose one of the templates
        * The template will then present you with options to `fill out` on the template.  These could be images that you need to upload, or, text fields that you need to fill out to complete the ad.
        * Once you have uploaded any required images and filled out all required text fields, click on `CREATE`
        * Your ad will be generated, and you will land on the **Proof Page** for this creative.
        * You may EDIT the fields for this ad / template, from the **Proof Page** click on the `EDIT` button to go to the **Item Page**
        * Then click on the `EDIT VALUES` button to edit the image / text fields for this templated ad.
        * And then click on `VIEW PROOF` to return to the **Proof Page**

## What Happens After Posting

Once your ad is created and you're viewing the **Proof Page**:

* **If draft mode is disabled** (default): Your ad will automatically be added to your campaign and will immediately start running on your connected screens
* **If draft mode is enabled**: Your ad will be created in draft state and you'll need to activate it manually
    * To activate: `Creatives -> {Your Ad} -> ACTIVATE`
    * To enable draft mode for future ads: `Settings -> Creatives -> New Ads Will Start in Draft State (Enable)`
* **View your ad in action**: Navigate to `Home -> Ads` to see your ad in the active ads list with real-time last play status
* **Return to your campaign**: Click on `Campaigns -> {Campaign}` to return to your campaign page
* **Edit your ad later**: Navigate to `Creatives -> {Your Ad}` to make changes

## Common Questions

**What image formats are supported?**

JPG (recommended) and PNG formats are supported. JPG files typically provide the best balance of quality and file size for digital billboards.

**What if my image is the wrong size?**

Use the `CROP` or `STRETCH` tools during the upload process to adjust your image to fit the screen dimensions. If you have multiple screen sizes, you can upload a different optimized image for each size using the `CHANGE THIS IMAGE` button on the **Item Page**.

**Can I edit my ad after posting?**

Yes! From the **Proof Page** click the `EDIT` button to modify your creative. You can:
- Change images by clicking `CHANGE THIS IMAGE` for each size
- Edit template values by clicking `EDIT VALUES` (for dynamic template ads)
- Update any creative properties

**How do I know if my ad is running?**

View the Campaign at `Campaigns -> {Campaign}` and view the list of ads that are at the top of the list and are checked.  These are your running ads.   Check that the ad that you just posted is in thist list.

Navigate to `Home -> Ads` to see all your active running ads with real-time last play status. This shows when each ad last played on a screen.

**What's the difference between Complete Creative and Dynamic Template?**

- **Complete Creative**: You provide fully designed images (JPG/PNG) for each screen size. Best when you have pre-designed ads from design software.
- **Dynamic Template**: You fill in fields (text, images) on a pre-built template. The template automatically generates all screen sizes. Best for consistent branding or data-driven content. Learn more in the [Template Designer General Navigation Guide](template-designer-general-navigation-guide.md).

**What is the Proof Page vs the Item Page**

* **Proof Page** displays a visual proof of your ad in every size on every screen.  Where available, it mocks up your ad on screens / billboards using google street view images, media owner provided images of the signs (We call this Lucit XR) and or AI generated default placeholder images.  A proof page can be shared with other people who do not have Lucit accounts

* **Item Page** THe Item page is where you can edit your ad.  You can perform the following actions
    * Add or Replace Images `Creatives -> {Item} -> Item Page -> CHANGE IMAGE`
    * Add additional sizes `Creatives -> {Item} -> Item Page -> CHANGE IMAGE`
    * Edit template values / images `Creatives -> {Item} -> Item Page -> EDIT VALUES`
    * Activate Draft Ads `Creatives -> {Item} -> Item Page -> ACTIVATE`
    * Delete Ads `Creatives -> {Item} -> Item Page -> DELETE`
    * View Proof page for an ad `Creatives -> {Item} -> Item Page -> VIEW PROOF`
    * Change an ad title / name `Creatives -> {Item} -> Item Page -> Title -> {PencilIcon}`
    * Add tags and geo tags to an ad `Creatives -> {Item} -> Item Page -> Tags -> {PencilIcon}`
    * Change the ads template `Creatives -> {Item} -> Item Page -> Templates -> CHANGE`
    * Edit the campaigns and triggers for an ad `Creatives -> {Item} -> Item Page -> Campaigns `
        * `Check / Plus Icon` to activate de-activatge
        * `Calendar Icon` to edit start stop dates and times
        * `Folder / Star icon` to edit data driven triggers


