---
title: "Digital Billboard Screen Format Reference - Lucit Platform"
description: "Complete technical reference of all 17 digital billboard screen formats supported by Lucit. Dimensions, aspect ratios, and specifications for DOOH displays."
keywords: "digital billboard formats, screen dimensions, DOOH formats, billboard specifications, aspect ratios"
---
# Screen Format Reference

Complete reference of all digital billboard screen formats supported by Lucit.

This reference contains **17 screen formats** currently supported by the Lucit platform. Each format is optimized for specific aspect ratios and use cases.

## Format Overview

| Format | Name | Recommended Dimensions (W×H) | Aspect Ratio Range |
| --- | --- | --- | --- |
| `oddvertical` | Extra Vertical | 350×1000 | 0 - 0.3999 |
| `vertical` | Vertical | 1080×1920 | 0.4 - 0.5999 |
| `tall` | Tall | 700×1000 | 0.6 - 0.7999 |
| `tallblock` | Tall Block | 540×600 | 0.8 - 0.9999 |
| `block` | Block | 600×600 | 1 |
| `oddblock` | Wide Block | 1000×833 | 1.0001 - 1.3999 |
| `oddball` | Wider Block | 1000×625 | 1.4 - 1.6999 |
| `widescreen` | Widescreen | 1920×1080 | 1.7 - 1.8 |
| `oddposter` | Tall Poster | 1000×526 | 1.8001 - 1.9999 |
| `poster` | Poster | 840×400 | 2 - 2.2222 |
| `medianposter` | Median Poster | 1000×447 | 2.2223 - 2.2499 |
| `median` | Median | 1000×400 | 2.25 - 2.7499 |
| `third` | Third | 1200×400 | 2.75 - 3.2665 |
| `bulletin` | Bulletin | 1400×400 | 3.2666 - 3.717 |
| `bulletinquarter` | Bulletin Quarter | 1000×267 | 3.7171 - 3.7499 |
| `quarter` | Quarter | 1600×400 | 3.75 - 4.25 |
| `quarterbeyond` | Quarter Beyond | 1000×234 | 4.2501+ |

## Format Details

### Recommended Dimensions

The listed dimenions (in pixels) is the recommended design dimensions for creatives within that size format.   This dimensions will be different than the actual screen size, which varys *greatly* among different types of screens and screen hardware.

The recommended dimensions are a fairly standard size to build that will work across most sizes in that format.   

When using the Lucit Template Designer, your creatives can be built to respond to all different sizes within the Aspect Ratio Range for the screen (to avoid squishing / stretching) your creatives. Learn more in the [Template Designer General Navigation Guide](template-designer-general-navigation-guide.md).

### Understanding Aspect Ratios

The aspect ratio ranges determine which format will be automatically selected based on your screen's dimensions:

- **Ratio = Width ÷ Height**
- Formats are ordered from most vertical (lowest ratio) to most horizontal (highest ratio)
- Each format has a minimum and maximum ratio range to ensure optimal display

### Format Selection

When you upload content or configure a screen, Lucit automatically:

1. Calculates your screen's aspect ratio
2. Matches it to the appropriate format range
3. Applies the corresponding template and sizing rules

### Standard Formats

The most Common formats in out-of-home typically depend on the type of environment the content is running in.   For each of the below categories, the *majority* of all screens in these environments fall into these formats : 

**Outdoor - Billboards**

* `tall`
* `poster`
* `third`
* `bulletin`
* `bulletinquarter`

**Outdoor - Urban Panels**

* `vertical`
* `tall`
* `widescreen`

**Indoor - Place based**

* `vertical`
* `tall`
* `widescreen`


---

*This documentation is automatically generated from the Lucit API. Last updated on 2026-01-16 *