---
title: "Template Designer General Navigation Guide"
description: "Comprehensive guide to navigation steps, paths, and actions in the Lucit Template Designer"
keywords: "template, template designer, creatives, dynamic creatives, dynamic creative design, WYSIWYG editor"
---

# Template Designer General Navigation Guide

## Table of Contents

- [Overview](#overview)
- [Key UI Sections](#key-ui-sections)
    - [Header](#header)
    - [Screen Format Bar](#screen-format-bar)
    - [Elements Panel](#elements-panel)
    - [Canvas](#canvas)
    - [Tools](#tools)
- [Related Documentation](#related-documentation)

## Overview

The Template Designer is a core Lucit tool and is the WYSIWYG editor for designing dynamic, responsive, data-driven ad creatives for digital out-of-home campaigns.

This guide will cover the basic navigation, options, settings, and tools that are available in the Template Designer.

You access templates by using your Account Profile and clicking on `Templates` in the menu. For general platform navigation, see the [General Navigation Guide](general-navigation-guide.md).

## Key Objectives

Templates created in the template designer are primarly used in one of 3 different ways

- Designing a responsive ad that will look good across all screen format sizes.  This ad can have dynamic elements on it that are being updated by data sources, or, could just be a template with no-dynamic elements.
- Designing a re-useable "Post Template" that a user to use to post multiple similar ads from by just filling in a few fields and/or adding an iamge
- Designing a template that will be attached directly to a data source that generates inventory items.  The data source will then use the template to generate many different ads from the same template, but with different data

## Key Concepts

In Lucit a single creative can be thought of as a container for 1 or more different size variations / formats for a single creative concept.  Instead of creating multiple different ads for every single size, in Lucit you design a single ad, but make adjustments to each size to make it fit / respond correctly.

This differs from most platforms for designing digital billboard creatives that require you to maintain lots of different ad sizes for every single creative.

In Lucit, these are called `Screen Formats` and in the Template Designer, you have a tab for each format.

## Key UI Sections

The following are the key major sections in the user interface:

### Header

#### Primary Image
* View the primary image that is used to visually identify this template
* `Click on the Image` to refresh the primary image

#### Title
* View the title of this creative template
* Edit the title: `Click the {PencilIcon}`

#### Actions

Contains various action buttons:

* **Post Ad** - Post a new ad from this template `Template -> Header -> Actions -> POST AD button`. See the [Post Ad Navigation Guide](post-ad-navigation-guide.md) for detailed instructions.
* **Undo / Redo** - Undo / Redo edits `Template -> Header -> Actions -> {BackArrowIcon}` / `Template -> Header -> Actions -> {ForwardArrowIcon}`
* **Save** - Save changes `Template -> Header -> Actions -> {FloppyDiskIcon}` (Note: templates automatically save most changes every few seconds)
* **Settings** - `Template -> Header -> Actions -> {GearIcon}`
    * Opens a dialog with the following tabs:
    * **FORMATS** - Edit the screen formats for this template. See the [Screen Format Reference](screen-format-reference.md) for all available formats.
    * **DYNAMIC FIELDS** - View information about dynamic fields on this template. Learn more about [Field Maps](../developer/fields/lucit-form-fields-specification.md) and [Macros](../developer/macros/field-map-macro-reference.md).
    * **FONTS** - View fonts that are in use on this template
    * **ADVANCED** - Edit advanced settings for this template:
        * **Keywords and Hashtags** - The description or searchable words to help users find this template
        * **Inventory Types** - Choose from different types of Inventory Item Classes for this template to control what types of dynamic elements (from the Inventory Item Field Map) will be available to you
        * **Photo Crop Ratio for Post** - For Post Templates (templates that users can manually create ads from) control the crop-ratio for a photo when the user uploads an image onto the template for the `Item Photo` dynamic field
        * **Minimum Render Sizes** - Specify the minimum pixel width/height for the rendering engine. Useful to prevent font distortion for small screens. Start with 800x800 and increase as needed if you are having font-distortion for your smaller screen sizes.
        * **Motion Capable** - Enable animation/video on this template
        * **Play Duration** - Set the play duration for the template (default: 15 seconds)
        * **Snapshot at Seconds** - When generating a static snapshot of an ad from this template, specify how long the snapshotting engine will wait before taking the snapshot (default: 0.5 seconds)
        * **Force Refresh Interval** - For templates that have lots of constant updates, set a forced refresh interval to force re-renders of this template. Typically used on templates that contain time sensitive dynamic elements like countdowns.
        * **Disable Unsafe Code Detection** - By default, the code editor will try to prevent most code it considers unsafe. Disable this feature here.
        * **Core Template Version** - Switch to different core template rendering engine versions.
* **More Actions** - `Template -> Header -> Actions -> {3VerticalDotsIcon}`
    * **Duplicate** - Duplicate this template or copy this template to another account `Template -> Header -> Actions -> {3VerticalDotsIcon} -> DUPLICATE`
    * **Publish** - Publish this template into an App that you have already created, or to a data source you have created. `Template -> Header -> Actions -> {3VerticalDotsIcon} -> PUBLISH` (In other words, make this template available to other users who install the app or data source that you have created)
    * **Delete** - Delete this template `Template -> Header -> Actions -> {3VerticalDotsIcon} -> DELETE`

### Screen Format Bar

* Switch between formats of your design by clicking on the tab for your desired format (e.g., Widescreen, Tall, Bulletin, etc.)
* Right-clicking on the format tab gives you the following actions:
    * **Remove Size** - Removes this size
    * **Sync Formats** - Sync (copy) all formatting / styles for all elements from another format size to this one *(Available when Editor Mode is set to Individual)*
    * **Code Editor** - Edit the CSS for this size *(Available when Editor Mode is set to Individual)*
* **Add a Format** - Click the `+` (plus) icon to add a new format/edit formats

Learn more about available screen formats in the [Screen Format Reference](screen-format-reference.md).

### Elements Panel

Contains expanding/collapsing accordions with the following sections:

#### Dynamic Data Elements

* **Preview Item** - Use the `PREVIEW ITEM` button to select an inventory item to use to render dynamic fields while designing the template. For instance, if you are designing a vehicle ad, choose a vehicle from the account's inventory to use while designing its dynamic parts (photo, make, model, etc.)
* **Elements** - Each available dynamic element is listed in this panel. Clicking on the element will add the element to your canvas. The list of fields comes from the Field Map for your Account, User, Digital Board, Inventory Item, and any apps that you have added. This list is further filtered based on the Inventory Types that are selected in your template settings. Learn more about [Field Maps](../developer/fields/lucit-form-fields-specification.md) and [Macros](../developer/macros/field-map-macro-reference.md).
* **Custom Field** - Click the `+` icon next to `Custom Field` to add a new custom field to your canvas. A common use of this feature is to combine or concatenate multiple dynamic/text fields together into a single text field.

#### Uploaded Assets

* Upload images and videos onto your template
* Click or drag and drop a file to upload it
* When uploading you will be asked the following:
    * **Element at Current Size** or **Background to Stretch to fill the screen**
    * **Add to All Sizes** or **Add to {current format} size only**

#### Backgrounds

* A list of Lucit-provided backgrounds you can use on your template

#### Shapes

* A list of Lucit-provided shapes you can use on your template

#### Text

* A list of Lucit-provided text elements you can use on your template, including custom fields like countdowns and calculated fields like monthly payment calculators

#### {Custom App}

* If you have added any apps to your account that provide Elements, those apps will each be listed in their own panel and allow you to add elements from those apps to your canvas

### Canvas

#### Editing Canvas

* The canvas is where editing the elements of your template design will happen
* Selected elements have a purple border
* Move elements by dragging them with your mouse
* Resize elements by using the resize handles that appear surrounding the element after clicking on it
* Rotate an element using the rotate handle
* Right-click on an element to access additional actions:
    * **Edit CSS / HTML** - Access the raw underlying CSS and HTML for this element
    * **Edit Settings** - Edit settings for the element:
        * **Layer Name** - Edit the layer name for this element that will appear in the layers panel
        * **Macro** - View the underlying macro that powers this element *(if dynamic)*. Learn more about [Macros](../developer/macros/field-map-macro-reference.md).
        * **Data Source** - Change the dynamic data source field (macro) that powers this element *(if dynamic)*
        * **Placeholder** - Edit/Change the placeholder text or image for this element *(if dynamic)*
        * **Optional Field** - Enable the checkbox in this setting to make this field optional during post ad.  (This defaults to off, meaning, by default, a field is required, unless you enable this)
    * **Copy** - Copy allows you to then paste by right-clicking on the canvas to duplicate it
    * **Paste** - Paste a copied element
    * **Copy Format** - Copy the formatting only (and then use paste format to paste)
    * **Paste Format** - Paste formatting onto this element. Optionally paste it across all screen formats, and optionally paste positioning as well
    * **Replace Image** - Replace this image with a new one by uploading a new image
    * **Duplicate** - Make a copy and paste it in one step
    * **Hide** - Hide this element
    * **Lock** - Lock this element so it cannot be moved or edited
    * **Delete** - Delete the element
    * **Send Backwards** - Send back 1 layer
    * **Send to Back** - Make this the bottom layer
    * **Bring Forwards** - Bring forward 1 layer
    * **Bring to Front** - Make this the top layer

#### Actions Bar

The actions bar is at the bottom of the canvas and contains the following:

* **Code Editor** - To open the code editor for this template, click on the `<>` icon. This allows you to edit the underlying HTML, CSS, and JavaScript for this template, and allows you to see the console logs for this template
* **Zoom** - Zoom in and out with the zoom dropdown
* **Play / Pause** - For animation and video-enabled templates, start play, stop play, and pause
* This panel also contains any messages and measurements/sizes if enabled on the Canvas Panel

### Tools

#### Edit Panel

The edit panel is available when clicking on any element in your canvas. The available tools depend on the type of element you have selected (Text, Image, Object, SVG).

Underneath the hood, each one of these tools updates CSS Styles on the element.

##### Text Elements

* **Text Color**
* **Background Color**
* **Opacity**
* **Rotate**
* **Borders**
* **Padding**
* **Font Family**
* **Font Size**
* **Max Font Size**
* **Max Characters**
* **Wrap Text**
* **Bold / Italic / Strikethrough / Underline**
* **Case (UPPERCASE, lowercase, Sentence Case)**
* **Line Height / Letter Spacing**
* **Font Stroke**
* **Align Left, Center, Right, Justify**
* **Vertical Align Start, Center, End**
* **Blur**
* **Box Shadow**
* **Text Shadow**
* **Show / Hide (Visibility)**
* **Clear Formatting**
* **Flip Normal, Left/Right, Upside Down, Both**
* **Format** Drop down of available formats for text elements
* **Animations** - Access to animation settings for this element *(if enabled)*

##### Images and Backgrounds

* **Background Color**
* **Opacity**
* **Rotate**
* **Borders**
* **Cropping and Sizing**
    * **No Cropping**
    * **Zoom to Fit**
    * **Stretch to Fill**
    * **Position**
* **Stretch to Fill Screen**
* **Preserve Aspect Ratio**
* **Blur**
* **Box Shadow**
* **Show / Hide (Visibility)**
* **Clear Formatting**
* **Flip Normal, Left/Right, Upside Down, Both**
* **Replace Image**
* **Animations** - Access to animation settings for this element *(if enabled)*

##### SVG Objects

* **Background Color**
* **Opacity**
* **Rotate**
* **Borders**
* **Stretch to Fill Screen**
* **Preserve Aspect Ratio**
* **Blur**
* **Box Shadow**
* **Show / Hide (Visibility)**
* **Clear Formatting**
* **Flip Normal, Left/Right, Upside Down, Both**
* **Animations** - Access to animation settings for this element *(if enabled)*

#### Canvas Panel

* **Background Color** - Main canvas background color. Defaults to white
* **Grid** - Enable the grid overlay
* **Enable Snapping** - Enable snapping to grid when moving/resizing
* **Show border on all elements** - Visually see all elements by adding a purple border
* **Show object sizes** - When clicking on an object, show its dimensions in the Canvas -> Action Bar
* **Show measurements in Pixels** - By default, measurements are in percentages; show them in pixels
* **Motion Capable** - Click `ENABLE` to enable animations for this template
    * **Play Duration** - Same as settings
    * **Snapshot at Seconds** - Same as settings
* **Editor Mode**
    * Editor mode describes what happens to other screen formats when you are editing one. There are 2 modes:
    * **All Sizes** (default) - In this mode, all changes you make to one format size will be reflected on all other sizes. This is the default starting mode.
    * **Each Size Independently** - In this mode, any changes you make to one format size will only be reflected on that size and will not apply anywhere else

#### Layers Panel

This panel contains the layers of your design (typically one for each element). With the following actions available on each one:

* **Name** - Double-click to edit the layer name
* **Move Handle** - Grab the `{2HorizontalLinesIcon}` to drag this layer up or down in the list
* **Visibility** - Click the `{EyeballIcon}` to toggle visibility
* **Lock** - Click the `{LockIcon}` to lock or unlock this layer from changes
* **Settings** - Click the `{GearIcon}` to edit the layer settings (See Edit Settings above for the options in this dialog)  This is the same as Right Clicking on the element in the canvas, and choosing "Edit Settings"
* **Delete** - Click the `{TrashCanIcon}` to delete this layer
* **More** - Click the `{3VerticalDotsIcon}` to access more actions:
    * **Recenter** - Find a lost layer by re-centering it
    * **Edit CSS / HTML** - Edit the underlying CSS and HTML for this layer

#### Screens Panel

* Use the screens panel to select a screen to be used when filling out dynamic elements that are tied to the `Digital Board` object (`digital_board.` macros)
* Only screens matching the currently selected format will be displayed
* Click on screen or use the up/down arrows to move through them
* Use the Search box to find screens

## Related Documentation

For more information about working with the Lucit platform, see:

* **[General Navigation Guide](general-navigation-guide.md)** - General navigation reference to the Lucit User Interface
* **[Post Ad Navigation Guide](post-ad-navigation-guide.md)** - Learn how to post ads from templates
* **[Campaign Page Navigation Guide](campaign-page-navigation-guide.md)** - Managing creatives within campaigns
* **[Screen Format Reference](screen-format-reference.md)** - Complete reference of all digital billboard screen formats
* **[Field Map Specification](../developer/fields/lucit-form-fields-specification.md)** - Understanding field maps for dynamic data
* **[Field Map Macro Reference](../developer/macros/field-map-macro-reference.md)** - Using macros in templates
