---
title: "User Roles Reference"
description: "Complete reference for Lucit user roles and permissions - account, agency, and operator access levels"
keywords: "lucit user roles, permissions, access control, account roles, agency roles"
---

# User Roles Reference

## Overview

User roles control permissions and access levels within Lucit accounts, agencies, and operator organizations. Each role has specific capabilities for managing campaigns, users, billing, and settings.

This reference documents **13 Account Roles** and **10 Agency/Operator Roles** available in the Lucit platform.

---

## Account Roles

Account roles control user permissions within advertiser accounts. These roles are assigned when adding users to an account.

| Role Key | Title | Description | Can Invite | Can Remove |
|----------|-------|-------------|------------|------------|
| `account_admin` | Account Admin | An admin of an account, can manage all aspects of this account including campaigns, billing, settings. | `account_user`, `account_exec`, `account_admin`, `account_user_re_broker`, `account_user_re_agent`, `billing_user`, `account_poster`, `account_poster_limited`, `user_view_only` | ✓ All Roles |
| `billing_user` | Account Billing User | This user's email address will get invoices for this account | `billing_user` | — |
| `account_bot` | Account Bot | An account bot -  Can't log in directly to the app, only programatically | — | — |
| `account_contact` | Account Contact | An account contact record - Can't log in or do anything | — | — |
| `account_poster` | Account Poster | Can post to an account's campaigns, edit their own posts, but not the posts of other account members | `account_poster` | — |
| `account_poster_limited` | Account Poster (Limited) | Can post using templates, edit thir own posts, but cannot perform any other actions | — | — |
| `account_user_re_agent` | Account Real Estate Agent | A special real estate user that belongs to an account but can only see their own listings | `account_user_re_agent`, `billing_user`, `account_poster`, `account_poster_limited`, `user_view_only` | — |
| `account_user_re_broker` | Account Real Estate Broker | A special real estate broker user that can be assigned child accounts as a broker | `account_user_re_broker`, `account_exec`, `account_user`, `billing_user`, `account_user_re_agent`, `account_poster`, `account_poster_limited`, `user_view_only` | ✓ All Roles |
| `account_user` | Account User | A normal user, either owns or works for this account, can view and edit campaigns for their account, change settings, upload creatives | `account_user`, `user_view_only` | — |
| `account_developer` | Developer / Programmer | This person is a software developer who works with scripts, API's and programming code | `account_developer` | — |
| `account_manager` | Lucit Account Manager | The Lucit account manager for this account.  This is the Lucit employee who is assigned to this account | `account_user`, `account_exec`, `account_manager`, `account_user_re_broker`, `account_user_re_agent`, `billing_user`, `account_poster`, `account_poster_limited`, `user_view_only` | — |
| `account_exec` | Operator Account Exec | Works for an out-of-home operator, access post / edit campaigns running on their screens | `account_user`, `account_exec`, `user_view_only` | — |
| `user_view_only` | View Only | Can view creatives, campaigns and analytics, but cannot post new ads, edit campaigns or settings | — | — |


---

## Agency & Operator Roles

Agency and Operator roles control user permissions within ad agencies and out-of-home operators. These roles are assigned when adding users to an agency or operator organization.

| Role Key | Title | Description | Can Invite | Can Remove |
|----------|-------|-------------|------------|------------|
| `account_exec` | Account Exec | An account exec that works for your organization.  Can add accounts and manage them. | `account_exec` | — |
| `ad_approver` | Ad Approver | A user that can do ad approvals and will get notifications about ad approvals | `ad_approver` | — |
| `agency_admin` | Admin | Administrator can edit all screens, users and settings | `account_exec`, `agency_admin`, `ad_approver`, `billing_user` | ✓ All Roles |
| `billing_user` | Billing User | This user's email address will get invoices for this company | `billing_user` | — |
| `agency_bot` | Bot | An bot - Useful for programmatic integrations and player API's.  Cannot log in | — | — |
| `agency_contact` | Contact | A contact record - Can't log in or do anything | — | — |
| `developer` | Developer / Programmer | This person is a software developer who works with scripts, API's and programming code | `developer` | — |
| `graphic_designer` | Graphic Designer / Art | This person creates ads and artwork for advertisers | `graphic_designer` | — |
| `account_manager` | Lucit Account Manager | The Lucit account manager for this operator or ad agency. | `account_exec`, `agency_admin`, `account_manager`, `ad_approver`, `billing_user` | — |
| `traffic` | Traffic / Scheduler | This person schedules and loads ads into the player / digital scheduler | `traffic` | — |


---

## Understanding Role Permissions

### Can Invite
The "Can Invite" column shows which roles each role can invite to the account/organization. This creates a permission hierarchy where higher-level roles can add lower-level users.

### Can Remove Users
Some roles have special permissions to remove users from the account or organization:

- **All Roles**: Can remove any user regardless of their role
- **Specific Roles**: Can only remove users with certain roles
- **None**: Cannot remove other users

---

## Common Use Cases

### Account Roles

- **Account Admin**: Full control over account settings, billing, campaigns, and users
- **Account User**: Day-to-day campaign management and creative work
- **Account Poster**: Content creators who only need to post ads
- **View Only**: Clients or stakeholders who need read-only access
- **Developer**: Technical users integrating via API

### Agency & Operator Roles

- **Agency Admin**: Full control over the agency organization and client accounts
- **Operator Account Exec**: Sales or account management staff at OOH operators
- **Billing User**: Finance staff who need to receive invoices

---

## How to Assign Roles

### For Account Users

Roles are assigned when inviting users to an account through the **Users & Invites** section:

1. Navigate to `Users & Invites` from the account menu
2. Click `INVITE SOMEONE TO THIS ACCOUNT`
3. Enter email address or phone number
4. Select the appropriate role from the dropdown (see roles table above)
5. Click `INVITE`

For more details, see [Account Users & Invites](general-navigation-guide.md) in the General Navigation Guide.

### For Agency & Operator Team Members

Roles are assigned when inviting team members through the **Team** section:

1. Navigate to `Team` from the agency or operator menu
2. Click `INVITE A TEAM MEMBER`
3. Enter email address or phone number
4. Select the appropriate role from the dropdown (see roles table above)
5. Click `INVITE`

For more details, see:
- [Ad Agency Team Management](general-navigation-guide.md#ad-agency-profile-menu-items) 
- [Operator Team Management](general-navigation-guide.md#operator-profile-menu-items)

---

## Related Resources

- [General Navigation Guide](general-navigation-guide.md)
