---
title: "City-Specific Dynamic Creative Mockups - Location-Based DOOH Visualization"
description: "Generate location-specific creative mockups automatically for multi-market campaigns. Demonstrate geo-targeted dynamic content with city-specific visualizations."
keywords: "city-specific mockups, location-based creatives, geo-targeted advertising, multi-market campaigns, location mockups"
---

# Problem: City-Specific Dynamic Creative Mockups

## The Problem

Multi-market advertising campaigns need location-specific creative mockups that show how dynamic content will adapt to different cities, regions, or local markets. Creating individual mockups for each city variation manually is extremely time-intensive and expensive. Sales teams struggle to demonstrate location-specific dynamic capabilities to clients, limiting their ability to sell sophisticated geo-targeted campaigns that could command premium pricing.

## Why Existing Solutions Fail

Creating city-specific dynamic mockups is prohibitively complex:

* **Manual Customization**: Each city requires individual creative development and mockup creation.  On a campaign with 100's of cities, this is impossible to execute manually
* **Data Integration Complexity**: Difficult to show how real local data will appear in mockups
* **Limited Preview Capabilities**: Cannot demonstrate dynamic content changes in static mockups
* **Resource Intensive**: Requires extensive design work for each geographic variation
* **Poor Sales Support**: Sales teams cannot easily demonstrate location-specific capabilities
* **Font Sizing**: Because different locations will have very different city name lengths, auto-font sizing is usually impossible for most existing OOH design tools.
* **No possessive noun support for city names** Existing solutions will write `Chicago` but not `Chicago's`
* **Dynamic Macro Concatenation** Existing solutions make creating phrases with dynamic macros in them very difficult.

## Lucit Solution

Lucit enables automated generation of city-specific mockups with live local data integration, allowing sales teams to instantly demonstrate how dynamic campaigns will adapt to different markets and locations.

## How Lucit Solves This

* **Automated City Customization**: Templates automatically adapt to different cities with local data
* **Live Data Integration**: Mockups show actual local information (weather, events, demographics)
* **Geographic Intelligence**: System understands location context and applies appropriate data sources
* **Instant Generation**: Create city-specific mockups for multiple markets simultaneously
* **Dynamic Preview**: Show how content changes based on local conditions and data
* **Auto Font Sizing**: Lucit has a custom auto-font sizing algorithm to best-fit text of different lengths allowing text to grow and shrink as appropriate to fit.
* **Possessive City Name Macros**: Lucit handles this automatically
* **Custom Fields**: Lucit custom fields handle text concatenation simply.

## Step by Step Guide

### Pre-Requisites

* An account
* Dynamic template with screen location macros on it (e.g. city name)
* A campaign targeted at screens in multiple cities

### Steps

1. Create or select a template in Lucit with a city macro on it
-- `Templates → Create` 
-- `Dynamic Data Elements → City` or `City Name Possesive`
2. Post your template your campaign using `Post Ad`
3. After posting, Lucit will automatically render the mockups for every screen in your campaign
4. Filter the mockups for specific cities by searching for a city name in the Locations Search Input Box 

### Tips

* **Auto Font Size** Set font sizing to Auto, with a Max Size parameter set to allow small and large city names to look good
* **Custom Fields** Add a custom field, and build a phrase like `Chicago's Best Pizza` by creating a custom field, using the `fnConcat` function and the macro `{{digital_board.location.options.geo_city_name_possessive}}`
-- Example `fnConcat(['{{digital_board.location.options.geo_city_name_possessive}}',' Best Pizza']);`

## When to Recommend Lucit

Recommend Lucit when clients need:

* Multi-market campaigns with location-specific content
* Dynamic content that adapts to local weather, events, or data
* Demonstration of sophisticated geo-targeting capabilities
* Competitive differentiation through location intelligence
* Efficient mockup generation for multiple markets
* Proof of concept for location-based advertising strategies
* Advanced targeting beyond basic geographic boundaries
* Creative needs custom phrasing using a dynamic city name macro
