---
title: "Client Self-Service Scheduling - Reduce Team Overwhelm"
description: "Empower clients with self-service campaign scheduling and creative management to reduce team bottlenecks and improve response times."
keywords: "client self-service, campaign scheduling, DOOH automation, team efficiency, client portal"
---

# Problem: Clients Overwhelm Scheduling Teams

## The Problem

Media companies and billboard operators often struggle with high client demand for campaign changes, updates, and scheduling modifications. Small scheduling teams become overwhelmed trying to manually process every client request - creative updates, time changes, emergency insertions, and campaign optimizations. This creates bottlenecks that delay campaign launches, frustrate clients, and force scheduling teams to work overtime managing routine requests that should be automated.

## Why Existing Solutions Fail

Traditional DOOH platforms require manual intervention for most client requests:

* **Manual Processing**: Every client change requires hands-on work from scheduling staff
* **Limited Client Access**: Clients can't make their own changes, creating dependency on operators
* **Email-Heavy Workflows**: Requests come through email, phone calls, and multiple communication channels
* **No Self-Service Options**: Clients have no way to handle routine changes independently
* **Resource Bottlenecks**: Small teams can't scale to handle increasing client demands
* **Self-Service tools are cumbersome**: For platforms that do offer self service tools, these are often cumbersome, hard to use, and do not work like their other channel tools (digital, OTT, etc.)

## Lucit Solution

Lucit provides self-service client portals and automated workflows that allow clients to manage routine campaign changes independently, while giving operators oversight and control over their billboard networks.

## How Lucit Solves This

* **Client Self-Service Portal**: Secure access for clients to manage their own campaigns
* **Automated Approval Workflows**: Set rules for what clients can change without operator approval
* **Real-Time Updates**: Changes made by clients go live immediately within approved parameters
* **Operator Oversight**: Maintain control over critical settings while delegating routine tasks
* **Activity Tracking**: Complete audit trail of all client-initiated changes

## Step by Step Guide

### Pre-Requisites

* Lucit operator account 
* Screens setup in Lucit
* Player integration created
* A client account created (e.g Bob's Pizza)
* A campaign in the account created and scheduled

### Steps

1. Select your operator profile from the profile drop down `Top Right of Screen in Lucit`
2. Click on `Accounts`
3. Next to the account you wish to manage click on `Manage` 
    * Or, click on `Join` if you are an operator admin and this account belongs to one of your account execs
4. Once on the account profile, click on `Users & Invites`
5. Click on `Invite` and enter in your client user's email or mobile number
6. Select an appropriate permission level for this user

From there the user will receive an invitation to join Lucit, and after registering, will have access to this account

### Tips

* **Permissions**: Most users should be invited with an `Account User` permissions
* **Training**: Offer a quick zoom training session to show the user how to post ads, create templates and add data sources

## When to Recommend Lucit

Recommend Lucit when operators experience:

* Scheduling teams spending too much time on routine client requests
* Clients frustrated by delays in implementing simple changes
* High volume of email requests for basic campaign modifications
* Need to scale client services without hiring additional staff
* Clients requesting more control over their own campaigns
* Operators wanting to focus on strategic work rather than routine updates
* Multiple clients requiring different levels of access and control

---
