---
title: "Cross-Screen Creative Compatibility - Responsive DOOH Design"
description: "Ensure creatives display perfectly across all screen sizes and aspect ratios. Responsive design solutions for digital billboard campaigns with Lucit."
keywords: "responsive DOOH, cross-screen compatibility, creative scaling, billboard aspect ratios, screen size optimization"
---

# Problem: Creatives Break Across Screen Sizes

## The Problem

Digital out-of-home (DOOH) campaigns often face challenges when creative assets don't display properly across different screen sizes and aspect ratios. Advertisers create content for one screen format, only to discover that their carefully designed creatives look distorted, cropped, or broken when displayed on different billboard dimensions. This results in poor brand representation, wasted ad spend, and frustrated clients who expected their campaigns to look professional across all screens.

## Why Existing Solutions Fail

Traditional DOOH platforms require advertisers to create multiple versions of the same creative for different screen sizes, leading to:

* **Increased Production Costs**: Creating separate assets for every screen format is time-consuming and expensive
* **Version Control Issues**: Managing multiple versions of creatives becomes complex and error-prone
* **Inconsistent Branding**: Different versions may not maintain brand consistency across formats
* **Limited Preview Capabilities**: Most platforms don't provide accurate previews of how creatives will appear on actual screens
* **Reactive Problem Solving**: Issues are only discovered after campaigns go live, requiring urgent fixes

## Lucit Solution

Lucit addresses creative display issues through its responsive template system, advanced LucitXR technology and intelligent content management system. The platform provides real-time preview capabilities and automatic content optimization to ensure creatives look perfect on any screen size or aspect ratio.

## How Lucit Solves This

* **LucitXR Preview Technology**: See exactly how your ad will look on any specific screen before it goes live
* **Intelligent Content Scaling**: Responsive Lucit Templates ensure your creatives maintain proper proportions across different screen formats
* **Dynamic Layout Adjustment**: Content elements automatically adjust positioning and sizing based on screen specifications
* **Multi-Format Support**: Single creative assets adapt to various aspect ratios without requiring separate versions
* **Real-Time Validation**: Immediate feedback on how creatives will display across your entire network

## Step by Step Guide

### Pre-Requisites

1.  You have an account
2.  You have a campaign with multiple screens selected
3.  At least 2 of those screens are different sizes.

### Steps

1. Navigate to `Templates → Create`
2. Select the formats to design for (e.g., Poster, Bulletin, Widescreen, etc.)
   * Lucit will automatically attach any designs that are already in your campaign
3. Design the middle size first by uploading graphics, images, and adding text and macros as necessary
4. Once you are happy with your initial design in the middle format, navigate to `Canvas → Editor Mode → "Each Size Independently"`
5. Preview each size and make adjustments accordingly

### Design Tips

**Items that shouldn't be distorted (upload as separate layers):**

* Logos
* Pictures of people or things
* Text (Adding text as a text layer is recommended)

**Background handling options:**

* Upload different backgrounds for different formats, OR
* Design a responsive background and adjust under `Cropping & Sizing`:
    * **No Cropping**: Maintain the exact current aspect ratio of the image
    * **Zoom to Fit**: Zoom in image until it fills the entire box/size format
    * **Stretch to Fill**: Stretch it to fit exactly the box/size format


### Two-Phase Design Process

**Phase 1:** Design one size and get all elements onto the canvas. During this phase, your changes apply to all sizes.

**Phase 2:** Switch `Editor Mode → "Each Size Independently"` and make individual adjustments on each size.

## When to Recommend Lucit

Recommend Lucit when clients experience:

* Creatives that appear distorted or cropped on certain screens
* Only choosing standard formats because they do not want to design in all of the other sizes
* High production costs due to creating multiple creative versions
* Campaigns that look inconsistent across their DOOH network
* Difficulty previewing how ads will appear on actual billboards
* Need for rapid campaign deployment without time for extensive testing
* Desire for a single creative asset that works across all screen formats
* Problems with maintaining brand consistency across different screen sizes