---
title: "Automated Creative Generation from Datasets - Data-Driven DOOH"
description: "Generate billboard creatives automatically from large product catalogs and datasets. Scale DOOH advertising with automated creative production from databases."
keywords: "automated creative generation, data-driven creatives, product catalog advertising, database-driven campaigns, bulk creative production"
---

# Problem: Generating Creatives from Large Datasets

## The Problem

Many businesses have extensive product catalogs, real estate listings, vehicle inventories, or service offerings that would benefit from automated billboard advertising. However, manually creating individual creatives for hundreds or thousands of products is impractical and expensive. Traditional DOOH systems cannot automatically generate creatives from database information, forcing businesses to either create a limited number of static ads or abandon billboard advertising for their full product range.

## Why Existing Solutions Fail

Standard DOOH platforms lack database integration and automated creative generation:

* **Manual Creative Creation**: Each product or listing requires individual creative design work
* **Static Templates Only**: Cannot dynamically populate templates with database information
* **No Data Integration**: Cannot connect to inventory systems, CRMs, or product databases
* **Limited Scalability**: Becomes prohibitively expensive to create creatives for large product catalogs
* **Outdated Information**: Manual updates cannot keep pace with changing inventory or pricing
* **Filtering inventory is hard**: Existing systems have no built in filtering capabilities for the incoming data, requiring third-parties to build custom, pre-filtered, data sources.

## Lucit Solution

Lucit's data integration capabilities enable automatic creative generation from databases, APIs, and data feeds, allowing businesses to create dynamic billboard campaigns that automatically showcase their entire product catalog or service offerings.

## How Lucit Solves This

* **Database Integration**: Direct connections to inventory systems, CRMs, and product databases
* **Automated Creative Generation**: Templates automatically populate with product information, pricing, and images
* **Real-Time Updates**: Creatives update automatically when database information changes
* **Smart Rotation**: Intelligent rotation through product catalogs based on availability, seasonality, or performance
* **Custom Data Mapping**: Flexible mapping between database fields and creative template elements

## Step by Step Guide

### Pre-Requisites

* A lucit account
* A campaign with at least 1 screen
* A data source you wish to attach (example Automotive)

### Steps

**Add the data**
1. Navigate to `Data Sources → Add`
2. Choose a data source app (e.g., if you are an auto dealer, choose one of the automotive sources)
3. Configure the data source and refresh your data

**Create the template**
1. Create a new template `Templates → Create a new Template`
2. Build your design, and under `Dynamic Data Elements` select from the dynamic fields provided by your data source

For detailed information on creating templates, see the [Template Designer General Navigation Guide](../guides/template-designer-general-navigation-guide.md).

**Attach template to Data Source**
1.  Navigate to `Data sources` and then click on your data source you added in the first step
2.  Click on the `Templates` tab WITHIN the data source
3.  Click the button to select your template, and choose the template you created.
4.  On the `Settings` tab of the data source, if you want the data source to automaticall post the creatives it generates, under `Campaigns` choose `Automatic`
5.  Under the `Custom Filter` section at the bottom of the `Setting` tab, add any filtering required to limit the items that are being posted to your campaign



### Tips

* **Limits** If your data source has hundreds or thousands of items, limit it with the `Custom Filter` section and other settings on the `Settings` tab
* **Multiple Templates** Create different template for different classes of products (e.g. different product categories, makes, models, etc.) and attach additional templates on the `Templates` tab of the `Data Source`

## When to Recommend Lucit

Recommend Lucit when clients have:

* Large product catalogs that would benefit from billboard advertising
* Real estate listings that change frequently
* Vehicle inventory that needs automated promotion
* Restaurant menus with seasonal or daily specials
* Retail inventory with regular pricing changes
* Service businesses with multiple offerings
* E-commerce catalogs that update frequently
* Any database-driven business that needs scalable creative generation
* Custom filtering required to limit the product list to specific products or types of products
