---
title: "Custom Font Support - Brand Typography for Dynamic DOOH"
description: "Maintain brand identity with full custom font support in dynamic billboard creatives. Use any typeface while keeping dynamic capabilities."
keywords: "custom fonts, brand typography, dynamic creatives, font support, brand consistency"
---

# Problem: Limited Font Support in Dynamic Creatives

## The Problem

Brand consistency requires specific fonts and typography in advertising campaigns. Dynamic billboard creatives often fail to support custom fonts or brand-specific typography, forcing advertisers to compromise their visual identity or abandon dynamic content altogether. This limitation results in generic-looking campaigns that don't match brand guidelines and reduces the effectiveness of dynamic advertising for brands with strong typographic identities.

## Why Existing Solutions Fail

Most DOOH platforms have restrictive font limitations:

* **System Fonts Only**: Limited to basic system fonts that don't match brand requirements
* **No Custom Font Upload**: Cannot add brand-specific or licensed fonts to templates
* **Font Rendering Issues**: Poor font rendering quality on high-resolution billboard displays
* **Limited Typography Controls**: Basic font sizing without advanced typography features
* **Brand Consistency Problems**: Dynamic content looks different from static brand materials

## Lucit Solution

Lucit supports custom font uploads and advanced typography controls, enabling dynamic creatives that maintain complete brand consistency and professional typographic quality across all screen sizes and resolutions.

## How Lucit Solves This

* **Custom Font Upload**: Support for brand-specific fonts including web fonts and licensed typefaces
* **Advanced Typography**: Full control over font sizing, spacing, kerning, and line height
* **High-Resolution Rendering**: Professional font rendering optimized for large-format displays
* **Template Font Libraries**: Reusable font collections for consistent brand application
* **Cross-Platform Compatibility**: Fonts render consistently across different screen types and sizes
* **Rendering high-res fonts and low resolutions**: Templates can be set with a minimum render size so the chrome browser snapshotting service will correctly render fonts before resizing the content back down.

## Step by Step Guide

### Pre-Requisites

* Brand font files (TTF, OTF, or web font formats)
* Font licensing that permits digital billboard usage
* Lucit account with custom font upload capabilities

### Steps

1. Navigate to `Templates → Create a new Template`
2. Add a text field `Text` click on some text
3. On the `Edit` tab, select a font, or choose `Upload` to upload your custom font

For more details on working with the Template Designer, see the [Template Designer General Navigation Guide](../guides/template-designer-general-navigation-guide.md).

**Font Distortion Prevention**
To prevent font distortion when using fonts designed for print (and not web), click on the `Settings` icon on the template `The Gear Icon` and then under `Advanced` set the minimum render height and width at a larger number such as `900`

### Tips

* **Font Licensing**: Verify that font licenses permit digital billboard usage
* **File Size**: Optimize font files for faster loading without compromising quality
* **Fallback Fonts**: Set backup fonts in case custom fonts fail to load
* **Readability Testing**: Test font legibility at actual billboard viewing distances
* **Brand Guidelines**: Document font usage guidelines for consistent application


## When to Recommend Lucit

Recommend Lucit when clients have:

* Strong brand typography requirements that must be maintained
* Custom or licensed fonts that are central to brand identity
* Dynamic campaigns that need to match existing brand materials
* High-end brands requiring premium typography quality
* Multiple brand variations requiring different font sets
* Complex typography needs beyond basic system fonts
* Requirements for professional typographic control in dynamic content
* Fonts designed for print are rendering poorly on small screen sizes

