---
title: "Real-Time Creative Control for DOOH Campaigns - Client Empowerment"
description: "Give clients instant control over billboard campaigns with real-time creative updates. Respond to breaking news and trending topics immediately with Lucit."
keywords: "real-time creative control, instant campaign updates, client control, live creative updates, responsive advertising"
---

# Problem: Real-Time Creative Control for Clients

## The Problem

Clients want immediate control over their billboard campaigns - the ability to make urgent changes, respond to breaking news, capitalize on trending topics, or adjust campaigns based on real-time business needs. Traditional DOOH systems require clients to go through operators for every change, creating delays that can cause missed opportunities, especially for time-sensitive promotions, crisis communications, or competitive responses.

## Why Existing Solutions Fail

Standard DOOH platforms centralize all control with operators:

* **Operator Dependency**: All changes must go through billboard operators, creating bottlenecks
* **Communication Delays**: Email and phone requests slow down urgent change implementation
* **Business Hours Limitations**: Changes can only be made during operator business hours
* **Approval Workflows**: Multiple approval steps delay time-sensitive campaign adjustments
* **No Emergency Access**: Clients cannot make urgent changes outside normal business processes

## Lucit Solution

Lucit provides secure client portals with real-time campaign control capabilities, allowing authorized clients to make approved changes instantly while maintaining operator oversight and network security.

## How Lucit Solves This

* **Secure Client Dashboard**: Direct access to campaign controls within defined parameters
* **Instant Updates**: Approved changes go live immediately without operator intervention
* **Permission-Based Control**: Granular permissions define what clients can change independently
* **Emergency Access**: 24/7 capability for urgent campaign modifications
* **Operator Oversight**: Complete audit trail and operator override capabilities maintained

## Step by Step Guide

### Pre-Requisites

* Lucit operator account 
* Screens setup in Lucit
* Player integration created
* A client account created (e.g Bob's Pizza)
* A campaign in the account created and scheduled

### Steps

1. Select your operator profile from the profile drop down `Top Right of Screen in Lucit`
2. Click on `Accounts`
3. Next to the account you wish to manage click on `Manage` 
    * Or, click on `Join` if you are an operator admin and this account belongs to one of your account execs
4. Once on the account profile, click on `Users & Invites`
5. Click on `Invite` and enter in your client user's email or mobile number
6. Select an appropriate permission level for this user

From there the user will receive an invitation to join Lucit, and after registering, will have access to this account

### Tips

* **Permissions**: Most users should be invited with an `Account User` permissions
* **Training**: Offer a quick zoom training session to show the user how to post ads, create templates and add data sources


## When to Recommend Lucit

Recommend Lucit when clients need:

* Immediate response capability for breaking news or trending topics
* Time-sensitive promotional campaigns requiring instant activation
* Crisis communication capabilities outside business hours
* Competitive response speed for market opportunities
* Event-driven campaigns that need real-time adjustments
* Global clients operating across multiple time zones
* High-volume campaigns requiring frequent content updates
* Autonomous campaign management with minimal operator dependency
