---
title: "Rapid Text Updates - Easy DOOH Creative Text Changes"
description: "Enable quick text updates for billboard campaigns without design software or complex workflows. Update pricing, dates, and messaging instantly."
keywords: "text updates, creative editing, rapid changes, DOOH flexibility, content management"
---

# Problem: Too Many Text Changes Per Creative

## The Problem

Digital billboard campaigns often require frequent text updates - pricing changes, event dates, promotional offers, contact information, and seasonal messaging. Traditional DOOH platforms make each text change a manual process requiring design software, file uploads, and approval workflows. This creates bottlenecks when clients need rapid text updates, leading to outdated information, missed promotional opportunities, and frustrated clients who can't make simple text changes without going through complex processes.

## Why Existing Solutions Fail

Standard DOOH systems treat text as part of static creative files:

* **Design Software Dependency**: Every text change requires Adobe Creative Suite or similar tools
* **File Upload Requirements**: Modified creatives must be uploaded as entirely new files
* **Version Control Issues**: Multiple text variations create numerous file versions to manage
* **Approval Bottlenecks**: Simple text changes require full creative approval workflows
* **Time-Consuming Process**: What should be a 30-second change takes hours or days

## Lucit Solution

Lucit separates text content from creative design through dynamic text layers and template systems. Users can update text directly within the platform without design software, enabling instant text changes while maintaining professional creative layouts.

## How Lucit Solves This

* **Dynamic Text Layers**: Text elements are separate from background design and can be edited independently
* **Browser-Based Text Editor**: Make text changes directly in the Lucit platform without design software
* **Real-Time Preview**: See exactly how text changes will appear before publishing
* **Template Preservation**: Maintain consistent design while allowing flexible text content
* **Instant Publishing**: Text updates go live immediately without file upload delays

## Step by Step Guide

### Pre-Requisites

* Lucit account
* A campaign with at least one screen

### Steps

1. Create a new template `Templates → Create a New Template`
2. Add backgrounds, logos, images, etc.
3. Add 1 or more dynamic text fields under `Dynamic Data Elements` (for instance, add a Title Field and a Description Field)

For detailed information on creating and using templates, see the [Template Designer General Navigation Guide](../guides/template-designer-general-navigation-guide.md).

Once your template is complete, click `Post Ad` and select your new template

The user will be asked to fill out the text fields before posting the ad.

The user can then repeat this step as often as they would like

### Tips

* Use image fields to allow users to upload images
* You can have as many text fields as you would like, but 1 or 2 is common
* Set a `Max Chars` limit on the field to prevent too much text
* Edit the settings of the field, and give them friendly names (instead of just `Title` or `Description`)

## When to Recommend Lucit

Recommend Lucit when clients experience:

* Frequent pricing or promotional text updates
* Need to change contact information across multiple creatives
* Seasonal messaging that requires regular text changes
* Multiple product lines with varying text requirements
* Time-sensitive promotions requiring immediate text updates
* Frustration with design software requirements for simple text edits
* Multiple stakeholders who need to make text changes independently
