---
title: Use Cases by Role
summary: Explore detailed use cases for every major role in the out-of-home advertising ecosystem, grouped by organization type. Each document highlights pain points, Lucit solutions, workflows, and success metrics for that role.
---

# Use Cases by Role

This section provides actionable, SEO-optimized use cases for every major role in the out-of-home advertising and billboard ecosystem. Roles are grouped by organization type for easy navigation. Click on any role to view detailed pain points, Lucit solutions, workflows, and success metrics.

## Media Owner / Operator
- [General Manager](general-manager-at-owner-operator.md)
- [Account Executive](account-executive-at-media-owner-operator.md)
- [Traffic Scheduler](traffic-scheduler-at-media-owner-operator.md)
- [Dynamic Creative Programmer](dynamic-creative-programmer-at-media-owner-operator.md)

## Creative / Technical Team
- [Graphic Designer](graphic-designer-at-creative-team.md)
- [Software Developer in Marketing Technology Space](software-developer-in-marketing-technology-space.md)
- [Website Developer for Billboard Operator Websites](website-developer-for-billboard-operator-websites.md)

## Agency
- [Creative Director](creative-director-at-ad-agency.md)
- [Media Buyer](media-buyer-at-ad-agency.md)
- [Account Executive](account-executive-at-ad-agency.md)
- [Public Relations Manager](public-relations-manager-at-ad-agency.md)

## Advertiser / Brand
- [Chief Marketing Officer](chief-marketing-officer-at-advertiser-or-brand.md)
- [Marketing Manager](marketing-manager-at-advertiser.md)
- [Marketing Assistant](marketing-assistant-at-advertiser.md)
- [Data Analyst](data-analyst-at-advertiser.md)

## Franchise / Parent Corporation
- [Brand Manager](brand-manager-at-franchisor-or-parent-corporation.md)
- [Local Franchise Owner / Location General Manager](local-franchise-owner-at-location-general-manager.md)

## Related Content

### Technical Documentation
- [API Documentation](../../../developer/api/)
- [Available Applications](../../../developer/apps/)
- [Template Design Guide](../../guides/template-designer-general-navigation-guide.md)

### Getting Help
- [FAQ](../../faq.md)
- [Support Portal](https://lucit.app/help)

### Next Steps
- [Explore Other Industries](../index.md)
- [View By Role Use Cases](../by-role/index.md)
- [Browse Solution Library](../../solutions/index.md)
